%--------------------------------------------------------------------------
% function [beam] = FT_init_thermal_beam(P,p,l,w,lambda)
%
% A Matlab function to initiate the thermal beam structure which stores 
% beam parameters needed for thermal calculations, such as the calculation 
% of thermal lenses and distortions.  The beam considered is a 
% Laguerre-Gauss beam.
%
% P:        Power in beam [W]
% p,l:      LG mode indices
% w:        Beam radius [m]
% lambda:   Wavelength [m]
%
% beam:     Structure storing beam parameters
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    09.02.2012
%--------------------------------------------------------------------------
%

function [beam] = FT_init_thermal_beam(P,p,l,w,lambda)

    beam.P = P;
    beam.p = p;
    beam.l = l;
    beam.w = w;
    beam.lambda = lambda;

end

