%--------------------------------------------------------------------------
% function [p_ls] =
% FT_calculate_fourier_bessel_coefficients(p,l,X,w,a,num_terms)
%
% A function which calculates the fourier bessel (FB) coefficients for the
% expansion of an LG mode in terms of bessel functions for use in
% approximations of thermal lenses and deformations.
%
% p,l:      LG mode indices
% X:        Reduced radiation constant
% w:        Beam radius [m]
% a:        Mirror radius [m]
% num_terms:Number of terms to include in approximation.  (N.B. Usually 50 
%           will give good approximation)
%
% p_ls:     Returned FB coefficients
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    10.02.2012
%--------------------------------------------------------------------------
%

function [p_ls] = FT_calculate_fourier_bessel_coefficients(p,l,X,w,a,num_terms)
    
    % Find zeros for zeta_ls coefficients
    zeta_ls = FT_bessel_zeros(2*l,X,num_terms);
    
    % Calculate y coefficients
    y_ls = zeta_ls.^2 * w^2 / (8*a^2);
    
    % Calculate FB coefficients
    p_ls = zeta_ls.^2 ./ ((X^2 + zeta_ls.^2 - 4*l^2) .* (besselj(2*l,zeta_ls).^2));
    p_ls = p_ls * factorial(p) / factorial(l+p) .* exp(-y_ls) .* y_ls.^l;
    p_ls = p_ls .* (FT_LaguerrePol(p,l,y_ls).^2);
    

end

