%--------------------------------------------------------------------------
% function [zeta_ls] = FT_bessel_zeros(l,X,num_terms)
%
% A function for Matlab which finds the solutions to equations of the form:
%
% y*J'_{l}(y) + X*J_{l}(y) = 0 (eq.1)
%
% where J are the bessel functions of the first kind.  These solutions are
% used in approximations of thermal lenses and distortions.
%
% l:        Azimuthal index (i.e. of incident beam)
% X:        Reduced radiation constant
% num_terms:Number of solutions of eq.1 to find
%
% zeta_ls:  Returned solutions
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    07.02.2012
%--------------------------------------------------------------------------
%

function [zeta_ls] = FT_bessel_zeros(l,X,num_terms)

    % Start off x range (initial dummy values)
    x = 0:0.001:20;
     
    % Bessel function to solve for zeta_ls, i.e. the zeros of f
    f = @(x)(l+X)*besselj(l,x) - x.*besselj(l+1,x);
    
    % Find num_terms zeros of f
    zeta_ls = FT_find_zeros(x,f,num_terms);
     
end

