%--------------------------------------------------------------------------
% function [c,p] =
% FT_approximate_paraboloid_for_thermal_lens(coeffs,X,a,w)
%
% A function for Matlab which computes the approximate paraboloid for a 
% thermal lens:
%
% coeffs:   Coefficients for expansion of thermal lens in terms of bessel
%           functions.
% X:        Reduced radiation constant.
% a:        Mirror radius [m].
% w:        Beam radius [m].
% 
% c,p:      Parameters for best fitted parabaloid:
%           Z = c*r.^2 +p
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    09.02.2012
%--------------------------------------------------------------------------
%

function [c,p] = FT_approximate_paraboloid_for_thermal_lens(coeffs,X,a,w)

    % Number of terms in expansion
    num_terms = length(coeffs);
    
    % Calculating bessel zeros
    zeta_0s = FT_bessel_zeros(0,X,num_terms);

    % Initial coefficients
    c = 0;
    p = 0;
    
    % Calculating approximate parabaloid parameters
    for s=1:num_terms
        
        c = c - 1/(4*a^2) * coeffs(s) * zeta_0s(s)^2 * exp(-zeta_0s(s)^2*w^2/(8*a^2));
        p = p + coeffs(s) * (1+zeta_0s(s)^2*w^2/(8*a^2)) * exp(-zeta_0s(s)^2*w^2/(8*a^2));
        
    end


end

