%--------------------------------------------------------------------------
% function [df,dphi] = FT_HG_frequency_splitting(L,Rc1,Rc2,order)
%
% A function for Matlab which calculates the difference in resonance 
% frequency (frequency splitting) for the HG modes of a particular order 
% in a linear cavity.  This difference corresponds to the frequency tuning 
% between the lowest and highest resonance frequencies of the modes of a 
% given order.
% 
% L:        Cavity length [m]
% Rc1:      Radius of curvature of the input mirror [m].  If the mirror is
%           astigmatic give Rc1 as a vector [Rc1x Rc1y] which refer to the 
%           radii of curvature in the x/y direction.  For flat mirrors we 
%           have Rc1 = 0;
% Rc2:      Radius of curvature of the end mirror [m]. [Rc2x Rc2y] for
%           astigmatic mirror.  For flat mirror Rc2 = 0;
% order:    Mode order
%
% df:       Frequency splitting [Hz]
% dphi:     Splitting in phase, i.e. difference in Gouy phase [deg]
%
% Charlotte Bond    26.11.2012
%--------------------------------------------------------------------------
%

function [df,dphi] = FT_HG_frequency_splitting(L,Rc1,Rc2,order)

    % Calculating the cavity resonance of smallest and largest resonant
    % frequency modes
    [f1,phi1] = FT_HOM_cavity_resonance(L,Rc1,Rc2,0,order);
    [f2,phi2] = FT_HOM_cavity_resonance(L,Rc1,Rc2,order,0);
    
    % Calculating frequency split in Hz and degrees
    df = abs(f1 - f2);
    dphi = abs(phi1 - phi2);
    
end

