%--------------------------------------------------------------------------
% [F] = FT_cavity_finesse(R1,R2)
%
% A function for Matlab which calculates the finesse of a two mirror 
% optical cavity.
%
% R1:   Power reflectivity of the input mirror
% R2:   Power reflectivity of the end mirror
%
% F:    Cavity finesse
%
% Charlotte Bond    25.11.2012
%--------------------------------------------------------------------------
%

function [F] = FT_cavity_finesse(R1,R2)
    
    % Calculate the amplitude coefficients
    r1 = sqrt(R1);
    r2 = sqrt(R2);
    
    % Calculate finesse
    F = pi ./ (2*asin((1-r1.*r2)./(2*sqrt(r1.*r2))));

end

