%--------------------------------------------------------------------------
% function [FWHM] = FT_cavity_FWHM(L,R1,R2)
%
% A function for Matlab which calculates the full-width-half-maxima (FWHM)
% of a two mirror optical cavity.
%
% L:    Cavity length [m]
% R1:   Power reflectivity of the input mirror
% R2:   Power reflectivity of the end mirror
%
% FWHM: Full-width-half-maxima of the cavity [Hz]
%
% Charlotte Bond    25.11.2012
%--------------------------------------------------------------------------
%

function [FWHM] = FT_cavity_FWHM(L,R1,R2)
 
    % Cavity finesse
    F = FT_cavity_finesse(R1,R2);
    
    % Free-spectral-range
    FSR = FT_cavity_FSR(L);
    
    % Calculate full-width-half-maxima
    FWHM = FSR/F;

end

