%--------------------------------------------------------------------------
% function [FSR] = FT_cavity_FSR(L)
%
% A function for Matlab which calculates the free-spectral-range (FSR) of
% an optical cavity.
% 
% L:    Cavity length (for a 2 mirror cavity) or half the round-trip length
%       otherwise [m]
%
% FSR:  Free-spectral-range [Hz]
%
% Charlotte Bond    25.11.2012
%--------------------------------------------------------------------------
%

function [FSR] = FT_cavity_FSR(L)

    % Speed of light
    c = 299792458;
    
    % Free-spectral-range
    FSR = c/(2*L);

end

