%--------------------------------------------------------------------------
% function [Lrt] = FT_FP_cavity_power(Pin,Lrt,lambda,L,T1,R1,R2)
%
% A function for Matlab which calculates the power circulating in a lossy
% Fabry-Perot cavity.  N.B. the circulating power is calculated just after
% reflection from the ITM (inside the cavity).
%
% Pin:      Power injected into the cavity [W]
% Lrt:      Round-trip loss inside the cavity
% lambda:   Laser light wavelength [m]
% L:        Cavity length [m]
% T1:       Transmission coefficient (power) of the ITM
% R1/R2:    Reflection coefficients (power) of the ITM/ETM
%
% Ploss:    Returned power circulating in a lossy cavity [W]
% P0:       Power in a perfect cavity [W]
%
% Charlotte Bond    29/01/2013
%--------------------------------------------------------------------------
% 

function [Ploss,P0] = FT_FP_cavity_power(Pin,Lrt,lambda,L,T1,R1,R2)
    
    % Wavenumber
    k = 2*pi/lambda;

    % Amplitude reflection coefficients
    r1 = sqrt(R1);
    r2 = sqrt(R2);

    % Calculate circulating power in perfect cavity
    P0 = Pin * T1/(1+R1*R2-2*r1*r2);

    % Calculate power in lossy cavity
    Ploss = P0/(1+Lrt/T1)^2;
    
end

