%--------------------------------------------------------------------------
% function [zmap] = FT_write_tilted_map(xbeta,ybeta,R,realsize,gridsize)
%
% A function for Matlab which creates a tilted mirror map and writes it to
% a file in the FINESSE map structure.  
%
% xbeta/ybeta:  Angles describing the tilt [rad]
% R:            Mirror map radius [m]
% realsize:     Real size of the map [m]
% gridsize:     Number of points (i.e. cols and rows) 
%
% zmap:         Returned Zernike map
%
% Charlotte Bond    17.01.2013
%--------------------------------------------------------------------------
%

function [zmap] = FT_write_tilted_map(xbeta,ybeta,R,realsize,gridsize)

    % Calculate amplitude of the tilt in nm
    A11 = 1e9*R*tan(xbeta);
    A1n1 = 1e9*R*tan(ybeta);
    
    % Initiate zernike coefficients structure
    zc = FT_init_zernike_coefficients(1);
    
    % Update zc with tilt amplitudes
    zc = FT_update_zernike_coefficient(zc,1,-1,A1n1);
    zc = FT_update_zernike_coefficient(zc,1,1,A11);
    
    % Map name
    mapname = 'tilted_map';
    
    % Create zernike map
    zmap = FT_create_synthetic_zernike_map(zc,'original',realsize,gridsize,R,mapname);
    
    % Write surface map for FINESSE
    filename = sprintf('%s.txt',mapname);
    FT_write_surface_map(filename,zmap);
    
    % Plot map
    FT_plot_mirror_map(zmap,0)


end

