function [zmap] = FT_write_curved_map(Rc,R,realsize,gridsize,filename)
    % use sagitta to get the amplitude of the polynomial
    b=2.*Rc;
    d = sqrt(b.^2-4.*(R.^2));
    h = [-b + d, -b-d]./2;
    A = abs(max(h))./1e-9; % get amplitude in nm
    
    % Create astigmatic map
    zmap = FT_create_individual_Znm_map(2,0,A,R,realsize,gridsize,0,0);
    
    % Calculate Z20 amplitude, representing common curvature (in nm)
    A20 = (1/2)*(Rc-sign(Rc)*sqrt(Rc^2-R^2));
    A20 = A20*1e9;
    
    % Flat mirror if Rc=0
    if Rc==0
        A20=0;
    end
    
    % Vector of zernike amplitudes and indices
    Amps = [0,A20,0];
    n = [2,2,2];
    m = [-2,0,2];
    
    % Calculate equivalent curvatures
    OF = FT_zernike_optical_features(Amps,R,n,m);
    Rcx = OF.value(2);
    Rcy = OF.value(1);
    
    % Output equivalent curvatures
    fprintf('Rcx:     %g \n',Rcx)
    fprintf('Rcy:     %g \n',Rcy)
    
    % Write map to file
    FT_write_surface_map(filename,zmap);

end

