%--------------------------------------------------------------------------
% function [profile] = FT_select_1D_map_data(map,option,offset)
%
% A function for Matlab which selects a line of data from a mirror map, 
% returning this 1D map data in the profile structure (see 
% FT_new_surface_profile).  
%
% map:      Original map in standard FT structure.
% option:   'horizontal':   Take data horizontally, i.e. over entier range 
%                           of x values for one y value.
%           'vertical':     Take data vertically, i.e. over entire range of
%                           y values for one x value.
% offset:   Offset from x0 or y0, the index where the line of data is taken 
%           from.  If the offset is 0 the data is taken across the centre 
%           (round(x0) or round (y)).
%
% profile:  Structure containg 1D surface data 
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    19.12.2011
%--------------------------------------------------------------------------
%

function [profile] = FT_select_1D_map_data(map,option,offset)
     
    % Take horizontal or vertical data
    if strcmp(option,'horizontal')
        line_idx = round(map.y0)+offset;
        r0 = map.x0;
        rstep = map.xstep;
    elseif strcmp(option,'vertical')
        line_idx = round(map.x0)+offset;
        r0 = map.y0;
        rstep = map.ystep;
    end

    % Select the relevant data
    data = FT_select_1D_data(map.data,option,line_idx);
    
    % Create profile structure from 1D map data
    profile = FT_new_surface_profile(data,r0,rstep,map.scaling);
    
    % Profile recnetered as nan points have been removed
    profile = FT_recenter_surface_profile(profile);

end

