%--------------------------------------------------------------------------
% function [data] = FT_select_1D_data(data_2D,option,line_idx)
%
% Matlab function which takes a 2D array of data and selects and returns 
% one line of the data.
%
% data_2D:          Original 2D data
% option:           'horizontal':   Take data horizontally, i.e. over 
%                                   entier range of x values for one y 
%                                   value.
%                   'vertical':     Take data vertically, i.e. over entire
%                                   range of y values for one x value.
% line_idx:         x or y (constant) index for line of data required.
%
% data:             Returned 1D data taken from the original data array.
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    19.12.2011
%--------------------------------------------------------------------------
%


function [data] = FT_select_1D_data(data_2D,option,line_idx)

    baseid = 'select_1D_data';
     
    % Error messages
    if (strcmp(option,'horizontal')==0 && strcmp(option,'vertical')==0)
        result='Invalid option: should be either "horizontal" or "vertical"';
        msgid=[baseid,':checkarguments']
        error(msgid,result);
    end
     
    [rows,cols] = size(data_2D);
    
    % Select one line of data
    if strcmp(option,'horizontal')
        data_1D(1:cols) = data_2D(line_idx,:);
    elseif strcmp(option,'vertical')
        data_1D(1:rows) = data_2D(:,line_idx);
    end
    
    % Remove any nan sections (i.e. when taking 1D data from maps)
    idx = find(isnan(data_1D)==0);
    
    % Remove nan data only at the edges
    i_min = min(idx);
    i_max = max(idx);
    data = data_1D(i_min:i_max);

end

