%--------------------------------------------------------------------------
% function [map_out,zc] = FT_remove_zernike_tilt_from_map(map)
%
% A function for Matlab which takes a map in the usual structure (see
% FT_new_surface_map.m) and removes tilt from the surface by calculating
% the overlap between the Zernike tilt terms and the map surface.
%
% map:      Input map
%
% map_out:  Output map with tilt removed
% zc:       Structure containing zernike coefficients from overlap with
%           map.
%
% Charlotte Bond    30.01.2013
%--------------------------------------------------------------------------
%

function [map_out,zc] = FT_remove_zernike_tilt_from_map(map)

    % Zernike map convolution up to order 1 (don't save the data)
    zc = FT_zernike_map_convolution(map,1,0);
        
    map_out = map;
    
    % Remove Z1-1 term
    Ao = FT_get_zernike_coefficient(zc,1,-1);
    map_out = FT_remove_zernike_polynomial_from_map(map_out,1,-1,Ao);
    
    % Remove Z11 term
    Ae = FT_get_zernike_coefficient(zc,1,1);
    map_out = FT_remove_zernike_polynomial_from_map(map_out,1,1,Ae);


end

