%--------------------------------------------------------------------------
% function [map_out,zc] = FT_remove_zernike_offset_from_map(map)
%
% A function for Matlab which takes a map in the usual format (see
% FT_new_surface_map.m) and removes an offset by performing an overlap with
% the Zernike term Z00.
%
% map:      Input map
% 
% map_out:  Output map with offset removed 
% zc:       Structure storing Zernike coefficents from overlap
%
% Charlotte Bond    30.01.2013
%--------------------------------------------------------------------------
%

function [map_out,zc] = FT_remove_zernike_offset_from_map(map)

    % Zernike map convolution up to order 0 (don't save the data)
    zc = FT_zernike_map_convolution(map,0,0);
        
    map_out = map;
    
    % Remove offset from map
    A = FT_get_zernike_coefficient(zc,0,0);
    map_out = FT_remove_zernike_polynomial_from_map(map_out,0,0,A);

end

