%--------------------------------------------------------------------------
% function [profile] = FT_recenter_surface_profile(profile)
%
% A function for Matlab which recenters the mirror surface data stored in 
% the profile structure, using a center of mass calculation, as used in 
% FT_recenter_mirror_map.
%
% profile:  Structure storing 1D data describing the surface height over a
%           mirror surface (see FT_new_surface_profile)
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    14.05.2012
%--------------------------------------------------------------------------
%

function [profile] = FT_recenter_surface_profile(profile)

    % Find all relevant ponints
    idx = find(isnan(profile.data)==0);
    a = length(idx);
    
    % Reset optical centre
    profile.r0 = sum(1:a)/a;

end

