%--------------------------------------------------------------------------
% function [profile] = FT_new_surface_profile(data,r0,rstep,scaling)
%
% Function for Matlab which creates a new variable with the profile
% structure, storing variables describing a surface profile.
%
% data:     vector of surface heights
% r0:       optical centre of the surface [in grid indices]
% rstep:    value giving the size of one grid step [m]
% scaling:  scaling factor to put data into metres
%
% profile:  structure containg surface profile data, defined below 
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    12.05.2012
%--------------------------------------------------------------------------
%

function [profile] = FT_new_surface_profile(data,r0,rstep,scaling)

    profile.data = data;
    profile.r0 = r0;
    profile.rstep = rstep;
    profile.scaling = scaling;

end

