%--------------------------------------------------------------------------
% function [z] = FT_harmonic_surface_distortion(r,slambda,phi)
%
% A function for Matlab which computes the relative surface amplitude 
% resulting from a distortion defined by a spatial wavelength, phase and 
% position from the centre of the surface.
%
% r:        Radial coordinate [m]
% slambda:  Spatial wavelength of the distortion [m]
% phi:      Spatial phase [degrees]
%
% z:        Surface heights [m]
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    12.05.2012
%--------------------------------------------------------------------------
%

function [z] = FT_harmonic_surface_distortion(r,slambda,phi)

    % Calculate spatial distortion
    % Wavenumber
    sk = 2*pi/slambda;
    
    % Phase in degrees
    phi = phi*pi/180;
    
    % Distortion
    z = cos(sk*r + phi);

end

