%--------------------------------------------------------------------------
% function [x,y] = FT_get_map_axes(map)
%
% A function for Matlab which computes the x and y axes for a map in the
% typical structure (see FT_new_surface_map.m).
%
% map:      Mirror map
%
% x/y:      x/y axes with 0,0 at map optical centre and scaled by relevant
%           x/y step sizes.
%
% Charlotte Bond    05/12/2012
%--------------------------------------------------------------------------
%

function [x,y] = FT_get_map_axes(map)
    
    % Map size
    [rows,cols] = size(map.data);

    % x and y indices
    x_index = linspace(1,cols,cols);
    y_index = linspace(1,rows,rows);
    
    % Scaling x and y axes and setting centre to 0,0
    x = (x_index-map.x0)*map.xstep;
    y = (y_index-map.y0)*map.ystep;

end

