%--------------------------------------------------------------------------
% function [zmap,zc] =
% FT_create_individual_Znm_map(n,m,A,r,realsize,gridsize,write,plot)
%
% A function for Matlab which creates a mirror map structure representing
% the surface defined by a particular zernike polynomial, Znm.
%
% n,m:      Indices of particular polynomial
% A:        Zernike polynomial amplitude [nm]
% r:        Surface radius [m]
% realsize: Real size of the map [m]
% gridsize: Number of points for map grid
% write:    1:  write map into FINESSE map file
%           0:  don't write map to file
% plot:     1:  plot map
%           0:  don't plot map
%
% zmap:     Returned zernike map
%
% Charlotte Bond    17.01.2013
%--------------------------------------------------------------------------
%

function [zmap] = FT_create_individual_Znm_map(n,m,A,r,realsize,gridsize,write, plot_)
    
    % Create zernike coefficient structure
    zc = FT_init_zernike_coefficients(n);
    
    % Update with the values for the particular polynomial
    zc = FT_update_zernike_coefficient(zc,n,m,A);
    
    % Map name
    mapname = sprintf('zmap_Z%g%g',n,m);
    
    % Create zernike map
    zmap = FT_create_synthetic_zernike_map(zc,'original',realsize,gridsize,r,mapname);
    
    % Write map into FINESSE file
    if write==1
        filename = sprintf('%s.txt',mapname);
        FT_write_surface_map(filename,zmap);
    end
    
    % Plot map
    if exist('plot_','var')
        if plot_==1
            FT_plot_mirror_map(zmap,0)
        end
    end
end

