%--------------------------------------------------------------------------
% Function: FT_finesse_plot_interpolation_data(interp_data, KNM)
%
% Plots 2 2D scatter plots of the phase and magnitude of the interpolated 
% values
%
% Input:
%   interp_data: Structure returned by FT_finesse_load_interpolation_data
%   KNM:         String referencing the coupling coeffient to use
%                e.g. 'K12'
%   N:           Sets which points to plot, e.g. 1:N:max(size(X))
%
% Daniel Brown 21/01/2013
%--------------------------------------------------------------------------
function FT_finesse_plot_interpolation_data(interp_data, KNM, N)

    ix=1:N:max(size(interp_data.(KNM).X));

    X = interp_data.(KNM).X(ix);
    Y = interp_data.(KNM).Y(ix);
    
    figure();
    Z = abs(interp_data.(KNM).Z(ix));
    scatter(X,Y,3,Z,'filled');
    title(sprintf('Magnitude of interpolated values for %s',KNM));
    xlabel('x [m]');
    ylabel('y [m]');
    xlim([min(X) max(X)]);
    ylim([min(Y) max(Y)]);
    axis([min(X) max(X) min(Y) max(Y)]);
    c=colorbar;
    ylabel(c,'Abs');
    colormap(FT_neg_colormap);
    set(gca,'DataAspectRatio',[1 1 1]);
    
    figure();
    Z = angle(interp_data.(KNM).Z(ix));
    scatter(X,Y,3,Z,'filled');
    title(sprintf('Phase of interpolated values for %s',KNM));
    xlabel('x [m]');
    ylabel('y [m]');
    xlim([min(X) max(X)]);
    ylim([min(Y) max(Y)]);
    c=colorbar;
    ylabel(c,'Phase [Rad]');
    colormap(FT_neg_colormap);
    set(gca,'DataAspectRatio',[1 1 1]);
end

