%--------------------------------------------------------------------------
% function [] = FT_LG_mode_finesse_lines(p,l,Pfactor)
%
% A function for Matlab which writes the text lines required for FINESSE to
% define an LG mode in terms of a sum of HG modes.  This text uses a defult
% laser name of 'i1'
% 
% NB: In the case where all of the input light from the laser is in this LG
% mode (i.e. Pfactor = 1) the HG00 mode is explicitly set to 0.  Otherwise 
% HG00 will have a relative power of 1 in the input beam unless 
% otherwise specified.
%
% p,l:          Indices defining LG mode
% Pfactor:      Fraction of input laser power in this LG mode
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond, Andreas Freise    29.07.2012
%--------------------------------------------------------------------------
%

function [] = FT_LG_mode_finesse_lines(p,l,Pfactor)
    
    % Default laser name
    lasername = 'i1';

    % Mode order
    order = abs(l)+2*p;

    % Get coefficients for LG mode in terms of sum of HG modes
    [c,n,m] = FT_lg2hg(p,l);
    
    % Calculate power coefficients for Finesse syntax and angle in degrees
    P = Pfactor*c.*conj(c);
    theta = angle(c)/pi*180;
    
    % Only put this line for none LG00 mode, and if all the power is in
    % this particular LG mode, otherwise might cause confusion if
    % there is an input of, for example, LG33 and LG00.
	if not(p==0 && l==0) && Pfactor==1
		% 0 power in default mode, HG00
		fprintf('tem %s 0 0 0 0\n',lasername);
	end

    % Add lines for each of the HG modes which make up the given LG mode
    for i=1:order+1
        fprintf('tem %s %d %d %g %g\n',lasername,n(i),m(i),P(i),theta(i));
    end

end

