%
%--------------------------------------------------------------------------
% FTE_iniial_mirror_tuning.m
%
%
% Part of the SimTools package
% Andreas Freise  30.01.2013
%--------------------------------------------------------------------------
%

% Description: 
% Keywords: 

clear all;

% initilise Finesse
FT=FT_init_Finesse();
% Create a new 'run' variable, a structure to hold Finess related data
Run1=FT_create_new_kat_run();
% Set temporary filename
Run1.filename='tmpfile';

% name of kat file to read in
infile='aLIGO_main_01.kat';
% name of kat file to write tuned setup
outfile='aLIGO_main_01_t.kat';

% read in block from testblock.kat
block=FT_read_blocks_from_file(inname);


% readding in the selected blocks
outbl(1)=FT_copy_block(block,'');
outbl(2)=FT_copy_block(block,'');
outbl(3)=FT_copy_block(block,'');

[mir_lines]=FT_find_element_in_active_block(myblock,1,'m');

for i=mir_lines
  [mir_name,p1,p2]=FT_get_element_from_line(myblock.txt_lines(i),2);
  if (mir_name=='m2')
    myblock.txt_lines(i)={FT_replace_value_in_line(myblock.txt_lines(i),3,0.7)};
  end
end



% finding reflectivity of PRM, SRM 

% finding tunings for ETMX, ETMY, BS, PRM

% making arm cavities resonant

% - adding detectors in trasnmission
% - finding ETMX tuning (power in X arm maximm)
% - finding ETMY tuning (power in Y arm maximm)

% adding detector for dark fringe
% - finding BS tuning (dark fringe = minimum)

% adding detectors in PRM
% - finding PRM tuning (power in PRC maximum)


% Start Finesse for the given file and read data from testblock.out
Run1=FT_run_kat_simulation(FT,Run1,0);

% clean directory again
FT_kat_clean(Run1);