%--------------------------------------------------------------------------
% function [Abs] = FT_GW_sidebands(lambda,h0,fsig,L,n)
%
% A function for Matlab which calculates the amplitude of the sidebands
% created when a light beam travels along a path modulated by a
% gravitational wave.
%
% lambda:   Wavelength of carrier light [m]
% h0:       Gravitational wave amplitude
% fsig:     Frequency of the gravitational wave [Hz]
% L:        Length of the path [m]
% n:        Index refection of the medium through which the beam travels
%
% Asb:      Amplitude of the sidebands [sqrt(W)]
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond    07.11.2012
%--------------------------------------------------------------------------
%

function [Asb] = FT_GW_sidebands(lambda,h0,fsig,L,n)
    
    % Carrier light parameters
    c = 299792458;
    f0 = c/lambda;
    w0 = 2*pi*f0;

    % Signal anglar frequency
    wsig = 2*pi*fsig;
 
    % Sideband amplitude
    Asb = (w0*h0./(2*wsig)) .* sin(wsig*L*n/(2*c));

end

