%--------------------------------------------------------------------------
% function [Abs] = FT_GW_sideband_amplitude(lambda,h0,fsig,L,n)
%
% A function for Matlab which calculates the amplitude of the sidebands
% created when a light beam travels along a path modulated by a
% gravitational wave.
%
% lambda:   wavelength of carrier light [m]
% h0:       gravitational wave amplitude
% fsig:     frequency of the gravitational wave [Hz]
% L:        length of the path [m]
% n:        index refection of the medium through which the beam travels
%
% Asb:      amplitude of the sidebands [sqrt(W)]
%
% Charlotte Bond    07.11.2012
%--------------------------------------------------------------------------
%

function [Asb] = FT_GW_sideband_amplitude(lambda,h0,fsig,L,n)
    
    % Carrier light parameters
    c = 3e8;
    f0 = c/lambda;
    w0 = 2*pi*f0;

    % Signal anglar frequency
    wsig = 2*pi*fsig;
 
    % Sideband amplitude
    Asb = (w0*h0./(2*wsig)) .* sin(wsig*L*n/(2*c));

end

