%---------------------------------------------------------------------  
% function [w0, z1, zr, w1, w2, q] = FT_cavity_gg2w0z(g1,g2,L,lambda)
% 
% For a linear, two mirror cavity, computes the waist 
% position, waist size, beam size on both mirrors, Rayleigh
% range.
%
% The computations are done using the resonator g parameters
%
% g1: reosonator g parameter for mirror1 
% g2: reosonator g parameter for mirror2
% L: resonator length (not round trip) [m]
% lambda: wavelength [m]
%
% w0: waist size (radius) [m]
% z1: distance between mirror one and waist [m] (negative number
%    means the waist is located before mirror 1, i.e. outside the
%    resonator
% zr: Rayleigh range [m]
% w1: beam size (radius) on mirror 1 [m]
% w2: beam size (radius) on mirror 2 [m]
% q1: the complex Gaussian beam parameter at mirror1
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Andreas Freise 29.08.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [w0,z1,zr,w1,w2, q1] = FT_cavity_gg2w0z(g1,g2,L,lambda)

  llp=lambda.*L/pi;
  gg=g1.*g2;
  nom=gg.*(1-gg);
  denom=g1+g2-2.*g1.*g2;
  
  % Siegman p. 746
  zr=sqrt(nom./denom.^2) .* L;
  z1=(g2*(1-g1))./denom .* L;
  w0=sqrt(llp.*sqrt(nom./denom.^2));
  w1=sqrt(llp.*sqrt(g2./(g1.*(1-g1.*g2))));
  w2=sqrt(llp.*sqrt(g1./(g2.*(1-g1.*g2))));
  q1=i*zr+z1;
  