%
%--------------------------------------------------------------------------
% An example function for Matlab demonstrating the use of SimTools for 
% mirror maps. The script reads in raw mirror map data and assigns it to a 
% standard map structure. The map is then recentered and invalid elements
% removed. The diameter of the mirror map is then calibrated to 1 inch 
% (2.54 cm).  The resulting mirror map is plotted
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond 04.05.2011
%--------------------------------------------------------------------------
%

% Description: Example for reading a Zygo mirror map
% Keywords: zygo, mirror, map, read

clear all;

% Example raw map file used in the example
filename='pr95_orientation1_C.asc.gz';

% File is .asc so filetype is 2
filetype=2;

% unzipping the file if required
filename=FT_check_for_gzip(filename);

% Read in zygo map file 
map=FT_read_zygo_map(filename, filetype);

% Recenter the mirror map using a centre of mass calculation
map=FT_recenter_mirror_map(map);

% Zoom in on the valid area of the mirror map and exclude non-valid
% elements
map=FT_remove_elements_outside_map(map);

% The chosen calibration diameter is 1 inch
D=2.54e-2;

% Calibrate the map diameter
map=FT_calibrate_map_diameter(map, D);

% Plot the mirror map
FT_plot_mirror_map(map,0);


