%
%--------------------------------------------------------------------------
%
% An example script for Matlab demonstrating some SimTools for mirror 
% maps. The script reads in raw mirror map data and assigns it to a 
% standard map structure. The resulting mirror map is plotted
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond 04.05.2011
%--------------------------------------------------------------------------
%

% Description: Example for reading a Zygo mirror map
% Keywords: zygo, mirror, map, read

clear all;

% Example raw map file used in the example
filename='pr95_orientation1_C.asc.gz';

% File is .asc so filetype is 2
filetype=2;

% unzipping the file if required
filename=FT_check_for_gzip(filename);

% Read in zygo map file 
map=FT_read_zygo_map(filename, filetype);

% Plot the resulting mirror map
FT_plot_mirror_map(map,0);


