%
%------------------------------------------------------------------
% function [map_out]=FT_virgo_aperture_map(map)
%
% Function for Matlab, takes a Virgo surface map and creates
% a corresponding amplitude map which represents the aperture
% given by the surface map.
% 
% filename: name of file to be written
% map:      the surface map (variable must be a 'map' structure,
%           see FT_new_surface_map)
% map_out   the corresponding aperture map 
%
% Andreas Freise  24.09.2008
%------------------------------------------------------------------
%

function [map_out]=FT_virgo_aperture_map(map)
  
  baseid='virgo_aperture_map';
  
  map_out=map;
  map_out.data(:)=0;
  
  [idx]=map_out.notnan;
  map_out.data(idx)=1;
  
  map_out.scaling=1.0;
  map_out.nan=isnan(map_out.data);
  map_out.notnan=not(map_out.nan);
  
  % type:         integer defining the type of the map 
  %               0: phase map
  %               1: absorption map
  %               2: reflectivity map
  % field:        integer defining which light field is affected
  %               0: both (reflected and transmitted
  %               1: reflected only
  %               2: transmitted only
  
  map_out.type=1;
  
  map_out.field=1;
  
  map_out.name=[map_out.name,'_aperture'];