%
%------------------------------------------------------------------
% function []=FT_write_map_fit_results(FID,map,Rc, x_tilt,y_tilt,offset,w, invert);
%
% Matlab function that prints the output of a mirror map pre-
% processing. Very specific utility function for other map functions
% and examples
%
% FID: filname or e.g. 1 for stdout
% map:      the surface map (variable must be a 'map' structure,
%           see FT_new_surface_map)
% Rc, x_tilt, y_tile, offset, w: [float] details of the fit.
% invert: bit coded switch: bit 1 indicated map has been flipped
%         horizontally, bit 2 means flipped vertically
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Andreas Freise  03.07.2008
%------------------------------------------------------------------
%

% Description: writes a the results of a surface fit to a map
% Keywords: write, map, tilt, curvature, fit



function []=FT_write_map_fit_results(FID,map,Rc,x_tilt,y_tilt,offset,w,invert);
  
  % use FID=1 for stdout
  fprintf(FID,'\n---------------------------------------------------------\n');
  fprintf(FID,'Map: %s\n',map.name);
  fprintf(FID,'Date: %s\n', datestr(now,'dd. mmmm yyyy (HH:MM:SS)'));
  fprintf(FID,'---------------------------------------------------------\n');
  fprintf(FID,'Radius of curvature Rc=%4.3f m\n',Rc);
  fprintf(FID,'Angles: x_tilt=%1.4g, y_tilt=%1.4g rad\n',x_tilt,y_tilt);
  fprintf(FID,'Offset: %3.3f nm\n',offset);
  fprintf(FID,'Weighting function used with w=%3.3f mm\n',w*1e3);
  if (invert)
    fprintf(FID,'Map flipped ');
    if (bitand(invert,1))
      fprintf(FID,'horizontally');
    end
    if (bitand(invert,1) && bitand(invert,2))
      fprintf(FID,' and vertically\n');
    elseif (bitand(invert,2))
      fprintf(FID,'vertically\n');
    end
  end
  fprintf(FID,'---------------------------------------------------------\n\n');

end 
