%
%--------------------------------------------------------------------------
% function [idx, npoints]=FT_select_area_in_map(map,r)
%
% A function for Matlab which returns the indices of the data points in a 
% Virgo mirror map which are located within an area around the center 
% defined by radius r.
%
% map   :   the surface map (variable converted to 'map' structure by
%           FT_read_virgo_map)
% r     :   radius of selected area [m]
%
% idx:    : integer, vector of indices, to be used as map(idx) 
% npoints : integer, length of idx
%
% Andreas Freise 05.09.2008
%--------------------------------------------------------------------------
%

function [idx, npoints]=FT_select_area_in_map(map,r)

  baseid='select_area_in_map';

  [rows,cols]=size(map.data);
  newx=(linspace(1,cols,cols)-map.x0)*map.xstep;
  newy=(linspace(1,rows,rows)-map.y0)*map.ystep;
  [Grid.X,Grid.Y] = meshgrid(newx,newy);
  Grid.R = sqrt(Grid.X.^2+ Grid.Y.^2);

  [idx1] = find(Grid.R<r);

  % remove NaN points
  idx=idx1(find(not(isnan(map.data(idx1)))));

  npoints=length(idx);

  if (npoints==0)
    msgid=[baseid,':isNaN'];
    msg='Area is NaN, maybe chose a larger radius';
    error(msgid,msg)
  end
    
