%
%--------------------------------------------------------------------------
% function[map_out, offset]=FT_remove_offset_from_mirror_map(map_in,r)
%
% A function for Matlab which takes the average value of the surface
% heights of a mirror map in the central region of the map. This 
% average is then removed from the data so that the central
% region is zero - on avaerage.
%
% map_in:   the surface map (converted to 'map' structure by
%           FT_read_virgo_map)
% r:        radius of area to average over
%
% map_out:  surface map with new set zero point
% offset:   the offset which has been removed from the data
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond, Andreas Freise  04.09.2008
%--------------------------------------------------------------------------
%

% Description: removes an offset from a mirror map
% Keywords: mirror, map, offset, remove

function[map_out,offset]=FT_remove_offset_from_mirror_map(map,r)

baseid='new_zero_point_for_mirror_map';

if (r>=map.xstep*map.x0 || r>=map.ystep*map.y0)
    msgid=[baseid,':checkw'];
    msg='Invalid value for beam radius, w.  Chose smaller value.';
    error(msgid,msg)
end

% select area in map of radius r
[idx, npoints]=FT_select_area_in_map(map,r);

% average over areas
offset=sum(sum(map.data(idx)))/npoints;

% remove average from new map
map_out=map;
[idx]=map.notnan;
map_out.data(idx)=map_out.data(idx)-offset;



