%
%--------------------------------------------------------------------------
% function [map] = FT_remove_elements_from_map(map,D)
%
% A function for Matlab which removes elements from the data defined in
% the map structure outside a given diameter, and sets them to nan.
%
% map:  mirror map in the standard structure
% D:    diameter outsiude of which points are removed [m]
%
% Charlotte Bond    03.05.2011
%--------------------------------------------------------------------------
%

function [map] = FT_remove_elements_from_map(map,D)
  
  D = D/map.xstep;
  radius=D/2;

  % Define x, y and radial coordinates for all the map data
  [rows,cols]=size(map.data);
  [X,Y]=meshgrid((1:cols)-map.x0,(1:rows)-map.y0);
  R=sqrt(X.^2+Y.^2);
  
  % Find all points outside the minimum radius
  outside=find(R>=radius);
  
  % Set these elements to nan 
  map.data(outside)=nan;
  
  % remove unnecessary points (nan points) outside the valid map grid.
  if D+2<rows && D+2<cols
    gridsize = round((ceil(D)+2)/2);
    x0 = round(map.x0);
    y0 = round(map.y0);
  
    new_data = map.data(y0-gridsize:y0+gridsize,x0-gridsize:x0+gridsize);
    map.data = new_data;
  end
  
  % Reassign nan values in map
  map.nan=isnan(map.data);
  map.notnan=not(map.nan);
  map = FT_recenter_mirror_map(map);

end

