%
%--------------------------------------------------------------------------
% function [map]=FT_recenter_mirror_map(map)
%
% A function for Matlab which tries to center mirror surface map as read by 
% FT_read_virgo_map or FT_read_zygo_map. It uses a simple center of gravity 
% computation.
%
% map:      the surface map 
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Andreas Freise  23.07.2008
%--------------------------------------------------------------------------
%

% Description: recenters a mirror map by computing the center of gravity
% Keywords: mirror, map, center

function [map]=FT_recenter_mirror_map(map)

  baseid='recenter_mirror_map';

  [rows,cols]=size(map.data);
  
  % Perform a simple centre of gravity calculation to find a new center 
  % of the map:
  [ridx,cidx]=find(map.notnan);
  
  x0=sum(cidx)/length(cidx);
  y0=sum(ridx)/length(ridx);
  
  FT_message(sprintf('move center (row,col) from (%d, %d) to (%d, %d)',map.y0,map.x0,y0,x0));
  
  map.x0=x0;
  map.y0=y0;

end