%
%------------------------------------------------------------------
% function [map] = FT_new_surface_map(name, data, type, field, x0, y0, xstep, ystep, scaling)
%
% Function for Matlab, creates a new variable of the surface_map
% structure
% 
% name:         string to be written into file header
% data:         2D array of double numbers
%               - for absorption and reflectivity maps the numbers 
%                 refer to light power and should be between 0 and 1
%               - phase maps are storing surface height in meters
% type:         integer defining the type of the map 
%               0: phase map
%               1: absorption map
%               2: reflectivity map
% field:        integer defining which light field is affected
%               0: both (reflected and transmitted
%               1: reflected only
%               2: transmitted only
% x0, y0:       double values defining the optical center of the map,
%               for center of grid use x0=(cols-1)/2, y0=(rows-1)/2
%               (these are referring to the grid index not the physical
%                size of the grid)
% xstep, ystep: double values giving the size of one map grid area
% scaling:      overall scaling factor of data values
% nan:          vector of indices of data values which are NaN 
%               (i.e. outside the mirror)
% notnan        vector of indices of data values which are *not* NaN 
%               (i.e. inside the mirror)
%
% map:          a structure as defined below
%
% Andreas Freise  03.07.2008
%------------------------------------------------------------------
%

function [map] = FT_new_surface_map(name, data, type, field, x0, y0, xstep, ystep, scaling)

map.name=name;
map.data=data;
map.type=type;
map.field=field;
map.x0=x0;
map.y0=y0;
map.xstep=xstep;
map.ystep=ystep;
map.scaling=scaling;
map.nan=isnan(data);
map.notnan=not(map.nan);

