%
%------------------------------------------------------------------
% function [rms]=FT_map_rms(map,radius)
%
% Function for Matlab, that computes the rms surface distortion
% of a mirror surface map.
% 
% map (structure):  the surface map (variable must be a 'map' structure,
%                   see FT_new_surface_map)
% radius (real):    radius over which the rms should be computed [m]
%
% rms (real):       rms value of surface distortions [m]
%
% Part of the SimTools package
% Andreas Freise  17.04.2010
%------------------------------------------------------------------
%

% Description: Computes the rms surface distortion of a mirror surface map
% Keywords: rms, surface, distortion, mirror, map, root, mean, square

function [rms]=FT_map_rms(map,radius)
  
  % select area defined by radius
  [idx, npoints]=FT_select_area_in_map(map,radius);

  %compute rms
  rms=sqrt(sum(sum(map.data(idx).^2))/npoints);

  % scale to meters
  rms=rms*map.scaling;
  