%
%--------------------------------------------------------------------------
% function[map_out]=FT_invert_mirror_map(map_in, direction)
%
% A function for Matlab which inverts a mirror map.
%
% map_in:   the surface map(variable converted to conventional 'map' 
%           structure for finesse, see e.g. FT_read_virgo_map)
% direction: bit coded integer:
%             0: do not invert
%             1: invert horizontally
%             2: invert vertically
%             3: invert in both directions
% map_out:  inverted surface map
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond, Andreas Freise  05.09.2008
%--------------------------------------------------------------------------
%

% Description: inverts (flips) a mirror map
% Keywords: mirror, map, invert, flip

function[map_out]=FT_invert_mirror_map(map_in, direction)

  baseid='invert_mirror_map';

  if(direction<0 || direction>3 || round(direction)~=direction)
    msg='Invalid value: invert direction must be 0,1,2 or 3';
    msgid=[baseid,':checkarguments']
    error(msgid,result);
  end

  map_out=map_in;
  [rows,cols]=size(map_in.data);
  
  if (bitand(direction,1))
    map_out.data=fliplr(map_out.data);
    map_out.x0=cols-map_out.x0;
  end
  
  if (bitand(direction,2))
    map_out.data=flipud(map_out.data);
    map_out.y0=cols-map_out.y0;
  end

  map_out.nan=isnan(map_out.data);
  map_out.notnan=not(map_out.nan);
  
end
  
