%
%--------------------------------------------------------------------------
% function [map] = FT_calibrate_map_diameter(map, diameter)
%
% A function for Matlab which changes the xstep and ystep scaling factors
% in the standard mirror structure to corespond with a mirror with a given
% diameter.
%
% map:      mirror map in the standard structure
% diameter: real diameter of the mirror in m
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Charlotte Bond 04.05.2011
%--------------------------------------------------------------------------
%

% Description: calibrates the delta x, y values of a map
% Keywords: calibrate, map

function [map] = FT_calibrate_map_diameter(map, diameter)
    
    % Find the radius of the map in data points
    R=FT_find_map_radius(map);
    
    % Calculate the required change in x and y for the overall given
    % diameter
    dx=diameter/(2*R);
    
    % Reset value in map
    map.xstep=dx;
    map.ystep=dx;

end

