%
%--------------------------------------------------------------------------
% function [wincam]=FT_read_WinCamD_ascii(filename)
%
% A function for Matlab which reads an ascii data file saved by
% an WinCamD.
%
% *Warning* this function is rather fragile as it expects a certain
% file format. Please adapt to your needs.
%
% filename: base name of the ASCII data file, eg. 'testdata.wct'
% wincam:  the data and header info stored as:
%           wincam.filename: basename of data files
%           wincam.cols: number of pixels in X-direction
%           wincam.rowst:  number of pixels in Y-direction
%           wincam.xpixel_size: size of pixels (along X) 
%           wincam.ypixel_size: size of pixels (along Y) 
%           wincam.data: image as data array
%
% Part of the SimTools package
% Andreas Freise 21.01.2011 andreas.freise@googlemail.com
%--------------------------------------------------------------------------
%

% Description: Reads an ascii data file saved by an WinCamD beam analyzer
% Keywords: read, WinCamD, ascii, data, beam, analyzer

function [wincam]=FT_read_WinCamD_ascii(filename)

  %% test if first channel file exists
    
  baseid='read_WinCamD_ascii';

  wincam.filename=filename;
    
  % Open file for reading
  [FID, result]=fopen(filename,'r');
    
  if (FID==-1)
    msgid=[baseid,':fileopen'];
    error(msgid,result);
  end

  % Read header
  % expecting format such as:
  % WinCamD text file ; 
  % Width = 512 ; 
  % Height = 512 ; 
  % X pixels size = 12.90 ; 
  % Y pixels size = 12.90 ; 
  
   % find the first line of the header
  found=FT_find_text_in_file(FID,'WinCamD text file');

  if (~found)
    msgid=[baseid,':fileread'];
    result='Could not find WinCamD header in file';
    error(msgid,result);
  end

  % reading header
  [wincam.cols]=fscanf(FID,'Width = %d ;');
  fgetl(FID);
  [wincam.rows]=fscanf(FID,'Height = %d ;');
  fgetl(FID);
  [wincam.xpixel_size]=fscanf(FID,'X pixels size = %g ;');
  fgetl(FID);
  [wincam.ypixel_size]=fscanf(FID,'Y pixels size = %g ;');
  fgetl(FID);

  % finished reading the header, now reading the data.
  wincam.data=zeros(wincam.rows,wincam.cols);
  for i=1:wincam.cols-1
  wincam.data(:,i)=fscanf(FID,'%g, ');
  fgetl(FID);
  end
    
  % close the file 
  fclose(FID);

    

