%
%--------------------------------------------------------------------------
% function [NA_data]=FT_read_HPNA_ascii(filename)
%
% A function for Matlab which reads an ascii data file saved by
% an HP network analyser (has been tested only with HP8751A).
%
% filename: name of the ASCII data file
% NA_data:  the data and header info 
%
% Part of the SimTools package
% Andreas Freise, 05.02.2010 afreise@googlemail.com
%--------------------------------------------------------------------------
%

% Description: Reads an ascii data file saved by an HP network analyser
% Keywords: read, ascii, data, HP, network, analyser

function [NA_data]=FT_read_HPNA_ascii(filename)

  baseid='read_HPNA_data';
    
  % Open file for reading
  [FID, result]=fopen(filename,'r');
    
  if (FID==-1)
    msgid=[baseid,':fileopen'];
    error(msgid,result);
  end
  
  NA_data.file=filename;
  
  % reading type
  s=fgetl(FID);
  cell=FT_split_line(s,'"');  
  NA_data.analyser=cell2mat(cell);
  
  % reading date
  s=fgetl(FID);
  cell=FT_split_line(s,'"');  
  NA_data.date=cell2mat(cell);

  % read rest of header 
  cell={};
  NA_data.header=[];;
  while (~feof(FID))
    s=fgetl(FID);
    if(~isempty(s))
      cell=FT_split_line(s,'"');
      if (~isempty(cell))
        if(strcmp(cell2mat(cell(1)),'Frequency'))
          break;
        end       
      NA_data.header=[NA_data.header,cell];
      end
    end
  end
  
  % assign data column names
  NA_data.columns=cell;  
  ncols=length(cell);
    
  formatstring='%f';
  for i=2:ncols
    formatstring=[formatstring, '%f'];
  end

  M=textscan(FID,formatstring);
  NA_data.data=cell2mat(M);

  return;
  
