%
%--------------------------------------------------------------------------
% function [agilent]=FT_read_Agilent6000_info(filename)
%
% A function for Matlab which reads an info file saved by
% an Agilent 6000 scope.
%
% filename: base name of the ASCII data file, eg. 'scope_4'
% agilent:  the data and header info stored as:
%           agilent.filename: basename of data files
%           agilent.channels: number of channels
%
% Part of the SimTools package
% Andreas Freise 08.02.2010 afreise@googlemail.com
%--------------------------------------------------------------------------
%

% Description: Reads info file saved by an Agilent 6000 scope
% Keywords: read, Agilent6000, info

function [agilent]=FT_read_Agilent6000_info(filename)
  
  baseid='read_Agilent6000_info';
    
  fname=[filename,'.txt'];
  
  fprintf(' Reading file %s.\n',fname);
  % Open file for reading
  [FID, result]=fopen(fname,'r');
    
  if (FID==-1)
    msgid=[baseid,':fileopen'];
    error(msgid,result);
  end

  agilent.filename=filename;
  
  line1=fgets(FID);

  agilent.channels=0;
  i=0;
  
  % reading the first 4 non-empty lines
  % this needs to be improevd so that it looks for the line 'Analg Ch State'
  % and stops at 'Anlg Ch Impedance' or any non 'Ch' line.
  while(i<4)
    line1=fgets(FID);
    if ~all(isspace(line))
      str=FT_split_line(line1,' ');
      if (~isempty(cell2mat(str)))
        chn=cell2mat(str(1));
        if (chn(1:2) == 'Ch')
          chn=cell2mat(str(2));
          chn=str2num(chn(1:length(chn)-1));
          if (chn >0 && chn < 5)
            chn=cell2mat(str(3));
            if (chn(1:2) == 'On')
              agilent.channels=agilent.channels+1;
            end
          else
            result=sprintf('error parsing line %d (wrong channel number %d)\n',i+1,chn);
            msgid=[baseid,':parsing'];
            error(msgid,result);
          end
        end
      end
    i=i+1;      
  end
  end
  fprintf(' Found %d channels.\n',agilent.channels);
  fclose(FID);

  
