%
%--------------------------------------------------------------------------
% function [agilent]=FT_read_Agilent6000_bin(filename)
%
% A function for Matlab which reads a binary data file saved by
% an Agilent 6000 scope.
%
% filename: base name of the binary data file, eg. 'scope_4'
% agilent:  the data and header info stored as:
%           agilent.filename: basename of data files
%           agilent.channels: number of channels
%           agilent.samples:  number of samples
%           agilent.x_data:   xaxis (row vector of agilent.samples length)
%           agilent.ch_data:  channel data, 
%                             matrix (agilent.samples x agilent.channels)
%
%
% filename: base name of the data file, eg. 'scope_4'
%
% Part of the SimTools package
% Andreas Freise 08.02.2010 afreise@googlemail.com
%--------------------------------------------------------------------------
%

% Description: Reads a binary data file saved by an Agilent 6000 scope
% Keywords: read, Agilent6000, bin, data

function [agilent]=FT_read_Agilent6000_bin(filename)
  
  baseid='read_Agilent6000_bin';
  
  agilent=FT_read_Agilent6000_info(filename);

  binname=[filename,'.bin'];
  
  [timeVector, voltageVector] = importAgilentBin(binname, 1);

  agilent.x_data=timeVector;
  agilent.samples=length(timeVector);
  agilent.ch_data=zeros(length(voltageVector), agilent.channels);
  agilent.ch_data(:,1)=voltageVector;
  
  for k=2:agilent.channels
    [timeVector, agilent.ch_data(:,k)] = importAgilentBin(binname, k);
  end
  

  