%
%--------------------------------------------------------------------------
% function []=FT_Agilent6000_bin_to_ascii(filename)
%
% A function for Matlab which reads a binary file saved by
% an Agilent 6000 scope and saves the data as an ascii file.
% Requires `importAgilentBin.m' which can be downloaded from 
% Agilent.
%
% filename: base name of the data file, eg. 'scope_4'
%
% Part of the SimTools package
% Andreas Freise 08.02.2010 afreise@googlemail.com
%--------------------------------------------------------------------------
%

% Description: Reads a binary file saved by an Agilent 6000 scope and saves
% Description: the data as an ascii file
% Keywords: convert, Agilent6000, bin, ascii, data

function [x_data,ch_data]=FT_Agilent6000_bin_to_ascii(filename)
  
  baseid='Agilent6000_bin_to_ascii';
  
  agilent=FT_read_Agilent6000_info(filename);

  binname=[filename,'.bin'];
  
  [timeVector, voltageVector] = importAgilentBin(binname, 1);

  x_data=timeVector;
  ch_data=zeros(length(voltageVector), agilent.channels);
  ch_data(:,1)=voltageVector;
  
  for k=2:agilent.channels
    [timeVector, ch_data(:,k)] = importAgilentBin(binname, k);
  end
  
  save_data=[x_data, ch_data];
  asciiname=[filename,'_ascii.txt'];
  fprintf(' Saving data in %s.\n',asciiname);
  
  save(asciiname, 'save_data','-ASCII');
  