%---------------------------------------------------------------------
% Data File: help_info_out
% Stores information about all functions in "/Users/adf/work/git/simtools/src"
% Last Updated: 2013-01-31 15:31:07.445335
%---------------------------------------------------------------------
index(1).name = 'FT_function_template';
index(1).path = '/Users/adf/work/git/simtools/src';
index(1).description = [{'(no description)'}];
index(1).keys = [{'(no marker)'}];
index(1).cats = [];
index(2).name = 'FT_help';
index(2).path = '/Users/adf/work/git/simtools/src';
index(2).description = [{'(no description)'}];
index(2).keys = [{'(no marker)'}];
index(2).cats = [];
index(3).name = 'FT_ABCD_lens';
index(3).path = '/Users/adf/work/git/simtools/src/ABCD_matrix';
index(3).description = [{'Computes the ABCD Matrix for a thin lens of focal lengh f'}];
index(3).keys = [{'matrix'},{'thin'},{'lens'}];
index(3).cats = [{'ABCD_matrix'}];
index(4).name = 'FT_ABCD_mirror';
index(4).path = '/Users/adf/work/git/simtools/src/ABCD_matrix';
index(4).description = [{'Computes the ABCD Matrix for the reflection of a curved mirror'},{'or beam splitter'}];
index(4).keys = [{'reflection'},{'mirror'},{'splitter'},{'matrix'}];
index(4).cats = [{'ABCD_matrix'}];
index(5).name = 'FT_ABCD_space';
index(5).path = '/Users/adf/work/git/simtools/src/ABCD_matrix';
index(5).description = [{'Computes the ABCD Matrix for a free space propagation of length L'}];
index(5).keys = [{'matrix'},{'space'},{'propagation'}];
index(5).cats = [{'ABCD_matrix'}];
index(6).name = 'FT_ABCD_trace_beam';
index(6).path = '/Users/adf/work/git/simtools/src/ABCD_matrix';
index(6).description = [{'(no description)'}];
index(6).keys = [{'(no marker)'}];
index(6).cats = [{'ABCD_matrix'}];
index(7).name = 'FT_cavity_ABCD_to_q';
index(7).path = '/Users/adf/work/git/simtools/src/ABCD_matrix';
index(7).description = [{'Computes the Gaussian beam parameter of cavity eigenmodes'}];
index(7).keys = [{'cavity'},{'eigenmode'},{'Gaussian'},{'parameter'},{'q'}];
index(7).cats = [{'ABCD_matrix'}];
index(8).name = 'FT_check_cavity_ABCD';
index(8).path = '/Users/adf/work/git/simtools/src/ABCD_matrix';
index(8).description = [{'computes the stability parameter m from the ABCD matrix of an'},{'optical resonator'}];
index(8).keys = [{'stability'},{'parameter'},{'m'},{'resonator'},{'check'},{'cavity'},{'m'}];
index(8).cats = [{'ABCD_matrix'}];
index(9).name = 'FT_compute_cavity_ABCD';
index(9).path = '/Users/adf/work/git/simtools/src/ABCD_matrix';
index(9).description = [{'Computes the ABCD matrix and stability parameter'},{'for an optical resonator'}];
index(9).keys = [{'matrix'},{'stability'},{'parameter'},{'compute'},{'cavity'},{'m'}];
index(9).cats = [{'ABCD_matrix'}];
index(10).name = 'FT_invert_ABCD';
index(10).path = '/Users/adf/work/git/simtools/src/ABCD_matrix';
index(10).description = [{'Computes the inverse of an ABCD matrix'}];
index(10).keys = [{'inverse'},{'matrix'},{'invert'}];
index(10).cats = [{'ABCD_matrix'}];
index(11).name = 'FT_multiply_ABCDs';
index(11).path = '/Users/adf/work/git/simtools/src/ABCD_matrix';
index(11).description = [{'Multiplies two ABCD matrices'}];
index(11).keys = [{'multiply'},{'multiplication'},{'matrix'}];
index(11).cats = [{'ABCD_matrix'}];
index(12).name = 'FT_q_ABCD_q';
index(12).path = '/Users/adf/work/git/simtools/src/ABCD_matrix';
index(12).description = [{'Transforms a Gaussian beam parameter by an ABCD matrix'}];
index(12).keys = [{'transform'},{'Gaussian'},{'parameter'},{'q'}];
index(12).cats = [{'ABCD_matrix'}];
index(13).name = 'FT_HermitePoly';
index(13).path = '/Users/adf/work/git/simtools/src/external';
index(13).description = [{'(no description)'}];
index(13).keys = [{'(no marker)'}];
index(13).cats = [{'external'}];
index(14).name = 'FT_FFT_cavity_scan';
index(14).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(14).description = [{'Reads temporary files and computes the circulating power'},{'as a function of the cavity tuning'}];
index(14).keys = [{'circulating'},{'power'},{'cavity'},{'scan'}];
index(14).cats = [{'FFT_propagation'}];
index(15).name = 'FT_FFT_lens';
index(15).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(15).description = [{'Computes the effect of a lens on a 2D complex light field'}];
index(15).keys = [{'2D'},{'field'},{'lens'}];
index(15).cats = [{'FFT_propagation'}];
index(16).name = 'FT_FFT_mirror';
index(16).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(16).description = [{'Computes the effect of a mirror on a 2D complex light field'}];
index(16).keys = [{'2D'},{'field'},{'mirror'}];
index(16).cats = [{'FFT_propagation'}];
index(17).name = 'FT_FFT_plot_field';
index(17).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(17).description = [{'Plots 2D arrays of a light field amplitude in the x-y plane'}];
index(17).keys = [{'plot'},{'field'},{'2D'},{'amplitude'}];
index(17).cats = [{'FFT_propagation'}];
index(18).name = 'FT_FFT_precompute_roundtrips';
index(18).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(18).description = [{'Computes fields inside a cavity and saves result in'},{'temporary data files'}];
index(18).keys = [{'field'},{'cavity'}];
index(18).cats = [{'FFT_propagation'}];
index(19).name = 'FT_FFT_propagate';
index(19).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(19).description = [{'Performs FFT propagation of a 2D complex light field'}];
index(19).keys = [{'propagate'},{'propagation'},{'2D'},{'field'}];
index(19).cats = [{'FFT_propagation'}];
index(20).name = 'FT_FFT_reorganise_tmp_files';
index(20).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(20).description = [{'Reads temporary files saved by FT_FFT_precompute_roundtrips'},{'and saves them in a new format for FT_FFT_cavity_scan'}];
index(20).keys = [{'reorganise'},{'tmp'},{'temporary'},{'format'},{'FT_FFT_precompute_roundtrips'},{'FT_FFT_cavity_scan'}];
index(20).cats = [{'FFT_propagation'}];
index(21).name = 'FT_FFT_required_cavity_roundtrips';
index(21).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(21).description = [{'Estimates required number of roundtrips to achieve requested'},{'accuracy in computing the circulating power'}];
index(21).keys = [{'estimate'},{'required'},{'accuracy'},{'cavity'},{'power'}];
index(21).cats = [{'FFT_propagation'}];
index(22).name = 'FT_FFT_required_scan_accuracy';
index(22).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(22).description = [{'Estimates the required number of steps in a full cavity scan'},{'to find peaks'}];
index(22).keys = [{'estimate'},{'required'},{'steps'},{'peaks'}];
index(22).cats = [{'FFT_propagation'}];
index(23).name = 'FT_FFT_results_buildup';
index(23).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(23).description = [{'Reads temporary files saved by FT_FFT_precompute_roundtrips'},{'and saves in a new format for FT_FFT_cavity_scan'}];
index(23).keys = [{'reorganise'},{'tmp'},{'temporary'},{'format'},{'FT_FFT_cavity_scan'},{'FT_FFT_precompute_roundtrips'}];
index(23).cats = [{'FFT_propagation'}];
index(24).name = 'FT_FFT_results_cavity_fields';
index(24).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(24).description = [{'Computes the reflected and transmitted fields of a cavity'}];
index(24).keys = [{'reflected'},{'transmitted'},{'field'}];
index(24).cats = [{'FFT_propagation'}];
index(25).name = 'FT_FFT_scan_range';
index(25).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(25).description = [{'Creates a vector of positions (tunings) for a cavity scan'}];
index(25).keys = [{'create'},{'vector'},{'position'},{'scan'},{'range'}];
index(25).cats = [{'FFT_propagation'}];
index(26).name = 'FT_hanning_window2D';
index(26).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(26).description = [{'(no description)'}];
index(26).keys = [{'2D'},{'hanning'},{'window'}];
index(26).cats = [{'FFT_propagation'}];
index(27).name = 'FT_init_grid';
index(27).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(27).description = [{'Creates a structure grid for storing useful information'}];
index(27).keys = [{'create'},{'grid'},{'init'}];
index(27).cats = [{'FFT_propagation'}];
index(28).name = 'FT_tilt_map';
index(28).path = '/Users/adf/work/git/simtools/src/FFT_propagation';
index(28).description = [{'Computes a tilted mirror map'}];
index(28).keys = [{'tilt'},{'tilted'},{'mirror'},{'map'}];
index(28).cats = [{'FFT_propagation'}];
index(29).name = 'FTE_FFT_premodecleaner';
index(29).path = '/Users/adf/work/git/simtools/src/FFT_propagation/example';
index(29).description = [{'(no description)'}];
index(29).keys = [{'(no marker)'}];
index(29).cats = [{'FFT_propagation'},{'example'}];
index(30).name = 'FTE_FFT_results_premodecleaner';
index(30).path = '/Users/adf/work/git/simtools/src/FFT_propagation/example';
index(30).description = [{'(no description)'}];
index(30).keys = [{'(no marker)'}];
index(30).cats = [{'FFT_propagation'},{'example'}];
index(31).name = 'FT_check_for_kat_binary';
index(31).path = '/Users/adf/work/git/simtools/src/finesse';
index(31).description = [{'(no description)'}];
index(31).keys = [{'(no marker)'}];
index(31).cats = [{'finesse'}];
index(32).name = 'FT_convert_finesse_4D';
index(32).path = '/Users/adf/work/git/simtools/src/finesse';
index(32).description = [{'(no description)'}];
index(32).keys = [{'convert'},{'finesse'},{'4D'}];
index(32).cats = [{'finesse'}];
index(33).name = 'FT_create_new_FT';
index(33).path = '/Users/adf/work/git/simtools/src/finesse';
index(33).description = [{'(no description)'}];
index(33).keys = [{'(no marker)'}];
index(33).cats = [{'finesse'}];
index(34).name = 'FT_create_new_kat_run';
index(34).path = '/Users/adf/work/git/simtools/src/finesse';
index(34).description = [{'(no description)'}];
index(34).keys = [{'(no marker)'}];
index(34).cats = [{'finesse'}];
index(35).name = 'FT_init_Finesse';
index(35).path = '/Users/adf/work/git/simtools/src/finesse';
index(35).description = [{'Creates a new "FT" structure'}];
index(35).keys = [{'create'},{'new'},{'FT'},{'structure'}];
index(35).cats = [{'finesse'}];
index(36).name = 'FT_kat_clean';
index(36).path = '/Users/adf/work/git/simtools/src/finesse';
index(36).description = [{'(no description)'}];
index(36).keys = [{'(no marker)'}];
index(36).cats = [{'finesse'}];
index(37).name = 'FT_make_finesse_video';
index(37).path = '/Users/adf/work/git/simtools/src/finesse';
index(37).description = [{'Reads finesse output file with x3axis and creates video output'}];
index(37).keys = [{'make'},{'finesse'},{'video'},{'create'},{'x3axis'}];
index(37).cats = [{'finesse'}];
index(38).name = 'FT_min_max';
index(38).path = '/Users/adf/work/git/simtools/src/finesse';
index(38).description = [{'(no description)'}];
index(38).keys = [{'(no marker)'}];
index(38).cats = [{'finesse'}];
index(39).name = 'FT_prepare_kat_filename';
index(39).path = '/Users/adf/work/git/simtools/src/finesse';
index(39).description = [{'(no description)'}];
index(39).keys = [{'(no marker)'}];
index(39).cats = [{'finesse'}];
index(40).name = 'FT_run_kat_simulation';
index(40).path = '/Users/adf/work/git/simtools/src/finesse';
index(40).description = [{'(no description)'}];
index(40).keys = [{'(no marker)'}];
index(40).cats = [{'finesse'}];
index(41).name = 'FT_save_finesse_map';
index(41).path = '/Users/adf/work/git/simtools/src/finesse';
index(41).description = [{'(no description)'}];
index(41).keys = [{'(no marker)'}];
index(41).cats = [{'finesse'}];
index(42).name = 'FT_set_kat_filenames';
index(42).path = '/Users/adf/work/git/simtools/src/finesse';
index(42).description = [{'(no description)'}];
index(42).keys = [{'(no marker)'}];
index(42).cats = [{'finesse'}];
index(43).name = 'FTE_finesse_01';
index(43).path = '/Users/adf/work/git/simtools/src/finesse/example';
index(43).description = [{'Example for using SimTools with Finesse: find the kat binary.'}];
index(43).keys = [{'finesse'},{'example'},{'simulation'},{'kat'}];
index(43).cats = [{'finesse'},{'example'}];
index(44).name = 'FTE_finesse_02';
index(44).path = '/Users/adf/work/git/simtools/src/finesse/example';
index(44).description = [{'Example for using SimTools with Finesse: read and write a Finesse input file.'}];
index(44).keys = [{'finesse'},{'example'},{'simulation'},{'kat'}];
index(44).cats = [{'finesse'},{'example'}];
index(45).name = 'FTE_finesse_03';
index(45).path = '/Users/adf/work/git/simtools/src/finesse/example';
index(45).description = [{'Example for using SimTools with Finesse: finding specific parameters.'}];
index(45).keys = [{'finesse'},{'example'},{'simulation'},{'kat'}];
index(45).cats = [{'finesse'},{'example'}];
index(46).name = 'FTE_finesse_04';
index(46).path = '/Users/adf/work/git/simtools/src/finesse/example';
index(46).description = [{'Example for using SimTools with Finesse: changing value of a constant.'}];
index(46).keys = [{'finesse'},{'example'},{'simulation'},{'kat'}];
index(46).cats = [{'finesse'},{'example'}];
index(47).name = 'FTE_finesse_ad_nm';
index(47).path = '/Users/adf/work/git/simtools/src/finesse/example_beam_analysis';
index(47).description = [{'Example for using SimTools with Finesse: get mode coefficients of output beam'}];
index(47).keys = [{'finesse'},{'example'},{'simulation'},{'kat'},{'amplitude'},{'mode'},{'coefficient'},{'Gauss'}];
index(47).cats = [{'finesse'},{'example_beam_analysis'}];
index(48).name = 'FTE_finesse_ccd';
index(48).path = '/Users/adf/work/git/simtools/src/finesse/example_beam_analysis';
index(48).description = [{'Example for using SimTools with Finesse: get mode coefficients of output beam'}];
index(48).keys = [{'finesse'},{'example'},{'simulation'},{'kat'},{'beam'},{'ccd'},{'mode'},{'coefficient'},{'Gauss'}];
index(48).cats = [{'finesse'},{'example_beam_analysis'}];
index(49).name = 'FT_add_line_to_block';
index(49).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(49).description = [{'(no description)'}];
index(49).keys = [{'(no marker)'}];
index(49).cats = [{'finesse'},{'input_file'}];
index(50).name = 'FT_comment_block';
index(50).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(50).description = [{'(no description)'}];
index(50).keys = [{'(no marker)'}];
index(50).cats = [{'finesse'},{'input_file'}];
index(51).name = 'FT_comment_lines_in_block';
index(51).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(51).description = [{'(no description)'}];
index(51).keys = [{'(no marker)'}];
index(51).cats = [{'finesse'},{'input_file'}];
index(52).name = 'FT_copy_block';
index(52).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(52).description = [{'(no description)'}];
index(52).keys = [{'(no marker)'}];
index(52).cats = [{'finesse'},{'input_file'}];
index(53).name = 'FT_copy_lines_block_to_block';
index(53).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(53).description = [{'(no description)'}];
index(53).keys = [{'(no marker)'}];
index(53).cats = [{'finesse'},{'input_file'}];
index(54).name = 'FT_create_new_block';
index(54).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(54).description = [{'(no description)'}];
index(54).keys = [{'(no marker)'}];
index(54).cats = [{'finesse'},{'input_file'}];
index(55).name = 'FT_find_element_in_active_block';
index(55).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(55).description = [{'(no description)'}];
index(55).keys = [{'(no marker)'}];
index(55).cats = [{'finesse'},{'input_file'}];
index(56).name = 'FT_find_element_in_all_blocks';
index(56).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(56).description = [{'(no description)'}];
index(56).keys = [{'(no marker)'}];
index(56).cats = [{'finesse'},{'input_file'}];
index(57).name = 'FT_find_element_in_block';
index(57).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(57).description = [{'(no description)'}];
index(57).keys = [{'(no marker)'}];
index(57).cats = [{'finesse'},{'input_file'}];
index(58).name = 'FT_find_text_in_active_block';
index(58).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(58).description = [{'(no description)'}];
index(58).keys = [{'(no marker)'}];
index(58).cats = [{'finesse'},{'input_file'}];
index(59).name = 'FT_find_text_in_all_blocks';
index(59).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(59).description = [{'(no description)'}];
index(59).keys = [{'(no marker)'}];
index(59).cats = [{'finesse'},{'input_file'}];
index(60).name = 'FT_find_text_in_block';
index(60).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(60).description = [{'(no description)'}];
index(60).keys = [{'(no marker)'}];
index(60).cats = [{'finesse'},{'input_file'}];
index(61).name = 'FT_index_of_block';
index(61).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(61).description = [{'(no description)'}];
index(61).keys = [{'(no marker)'}];
index(61).cats = [{'finesse'},{'input_file'}];
index(62).name = 'FT_list_block_names';
index(62).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(62).description = [{'(no description)'}];
index(62).keys = [{'(no marker)'}];
index(62).cats = [{'finesse'},{'input_file'}];
index(63).name = 'FT_print_block';
index(63).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(63).description = [{'(no description)'}];
index(63).keys = [{'(no marker)'}];
index(63).cats = [{'finesse'},{'input_file'}];
index(64).name = 'FT_read_blocks_from_file';
index(64).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(64).description = [{'(no description)'}];
index(64).keys = [{'(no marker)'}];
index(64).cats = [{'finesse'},{'input_file'}];
index(65).name = 'FT_read_kat_constant';
index(65).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(65).description = [{'(no description)'}];
index(65).keys = [{'(no marker)'}];
index(65).cats = [{'finesse'},{'input_file'}];
index(66).name = 'FT_remove_comment_char_in_block';
index(66).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(66).description = [{'(no description)'}];
index(66).keys = [{'(no marker)'}];
index(66).cats = [{'finesse'},{'input_file'}];
index(67).name = 'FT_remove_lines_from_block';
index(67).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(67).description = [{'(no description)'}];
index(67).keys = [{'(no marker)'}];
index(67).cats = [{'finesse'},{'input_file'}];
index(68).name = 'FT_search_string_for_block_commands';
index(68).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(68).description = [{'(no description)'}];
index(68).keys = [{'(no marker)'}];
index(68).cats = [{'finesse'},{'input_file'}];
index(69).name = 'FT_uncomment_block';
index(69).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(69).description = [{'(no description)'}];
index(69).keys = [{'(no marker)'}];
index(69).cats = [{'finesse'},{'input_file'}];
index(70).name = 'FT_uncomment_lines_in_block';
index(70).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(70).description = [{'(no description)'}];
index(70).keys = [{'(no marker)'}];
index(70).cats = [{'finesse'},{'input_file'}];
index(71).name = 'FT_write_blocks_into_file';
index(71).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(71).description = [{'(no description)'}];
index(71).keys = [{'(no marker)'}];
index(71).cats = [{'finesse'},{'input_file'}];
index(72).name = 'FT_write_kat_constant';
index(72).path = '/Users/adf/work/git/simtools/src/finesse/input_file';
index(72).description = [{'(no description)'}];
index(72).keys = [{'(no marker)'}];
index(72).cats = [{'finesse'},{'input_file'}];
index(73).name = 'FT_read_kat_output_data';
index(73).path = '/Users/adf/work/git/simtools/src/finesse/output_file';
index(73).description = [{'(no description)'}];
index(73).keys = [{'(no marker)'}];
index(73).cats = [{'finesse'},{'output_file'}];
index(74).name = 'FT_read_kat_output_header';
index(74).path = '/Users/adf/work/git/simtools/src/finesse/output_file';
index(74).description = [{'(no description)'}];
index(74).keys = [{'(no marker)'}];
index(74).cats = [{'finesse'},{'output_file'}];
index(75).name = 'FT_CON_field';
index(75).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(75).description = [{'Fills a 2D grip with the field amplitudes for '},{'a conical beam at the waist'}];
index(75).keys = [{'2D'},{'fill'},{'conical'},{'amplitude'},{'waist'}];
index(75).cats = [{'GaussBeams'}];
index(76).name = 'FT_conv_fields';
index(76).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(76).description = [{'Computes the scalar product between two complex 2D data arrays'}];
index(76).keys = [{'scalar'},{'dot'},{'product'},{'2D'},{'conv'},{'fields'}];
index(76).cats = [{'GaussBeams'}];
index(77).name = 'FT_gauss_coefficients_to_field';
index(77).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(77).description = [{'Computes a complex field array from '},{'a set of Gaussian mode coefficients'}];
index(77).keys = [{'Gaussian'},{'mode'},{'coefficient'},{'field'}];
index(77).cats = [{'GaussBeams'}];
index(78).name = 'FT_get_mode_coefficient';
index(78).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(78).description = [{'Returns the value of a mode coefficient in a structure "gc"'}];
index(78).keys = [{'get'},{'mode'},{'coefficient'},{'gc'}];
index(78).cats = [{'GaussBeams'}];
index(79).name = 'FT_HG_field';
index(79).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(79).description = [{'Fills a 2D grid with complex field amplitudes for a Hermite-Gauss beam'}];
index(79).keys = [{'fill'},{'2D'},{'HG'},{'field'},{'amplitude'},{'Hermite'},{'Gauss'}];
index(79).cats = [{'GaussBeams'}];
index(80).name = 'FT_init_gauss_coefficients';
index(80).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(80).description = [{'Returns an empty array for storing mode coefficients'}];
index(80).keys = [{'mode'},{'Gaussian'},{'coefficients'},{'empty'}];
index(80).cats = [{'GaussBeams'}];
index(81).name = 'FT_init_gauss_param';
index(81).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(81).description = [{'Creates a structure "gp" storing the Gaussian beam parameter "q"'}];
index(81).keys = [{'Gaussian'},{'parameter'},{'q'},{'gp'},{'create'},{'init'}];
index(81).cats = [{'GaussBeams'}];
index(82).name = 'FT_LG_cos_field';
index(82).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(82).description = [{'Fills a 2D grid with complex field amplitudes for'},{'a (co-)sinusoidal Laguerre-Gauss beam'}];
index(82).keys = [{'LG'},{'cos'},{'field'},{'fill'},{'2D'},{'amplitude'},{'Laguerre'},{'Gauss'}];
index(82).cats = [{'GaussBeams'}];
index(83).name = 'FT_LG_field';
index(83).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(83).description = [{'Fills a 2D grid with complex field amplitudes '},{'for a Laguerre-Gauss beam'}];
index(83).keys = [{'LG'},{'field'},{'fill'},{'2D'},{'amplitude'},{'Laguerre'},{'Gauss'}];
index(83).cats = [{'GaussBeams'}];
index(84).name = 'FT_mode_coefficients_to_field';
index(84).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(84).description = [{'Computes a complex field array from a set of Gaussian mode coefficients'}];
index(84).keys = [{'mode'},{'coefficient'},{'field'},{'Gaussian'}];
index(84).cats = [{'GaussBeams'}];
index(85).name = 'FT_new_mode_coefficients';
index(85).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(85).description = [{'Returns an empty array for storing mode coefficients'}];
index(85).keys = [{'empty'},{'mode'},{'coefficient'},{'new'}];
index(85).cats = [{'GaussBeams'}];
index(86).name = 'FT_power_in_field';
index(86).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(86).description = [{'Computes the total power in a complex field array'}];
index(86).keys = [{'total'},{'power'},{'complex'},{'field'}];
index(86).cats = [{'GaussBeams'}];
index(87).name = 'FT_q_to_Psi';
index(87).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(87).description = [{'Computes the Gouy Phase Psi(z) from the Gaussian beam parameter q'}];
index(87).keys = [{'Gaussian'},{'parameter'},{'q'},{'Guoy'},{'phase'},{'psi'}];
index(87).cats = [{'GaussBeams'}];
index(88).name = 'FT_q_to_Rc';
index(88).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(88).description = [{'Computes the radius of curvature of a phase front from the Gaussian '},{'beam parameter q'}];
index(88).keys = [{'radius'},{'curvature'},{'Gaussian'},{'parameter'},{'q'},{'RC'}];
index(88).cats = [{'GaussBeams'}];
index(89).name = 'FT_q_to_w';
index(89).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(89).description = [{'Computes the beam radius from the Gaussian beam parameter q'}];
index(89).keys = [{'Gaussian'},{'parameter'},{'q'},{'radius'},{'w'}];
index(89).cats = [{'GaussBeams'}];
index(90).name = 'FT_q_to_w0z';
index(90).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(90).description = [{'Computes the waist radius and waist position from the Gaussian beam'},{'parameter q'}];
index(90).keys = [{'waist'},{'radius'},{'position'},{'Gaussian'},{'parameter'},{'q'},{'w0z'}];
index(90).cats = [{'GaussBeams'}];
index(91).name = 'FT_q_to_zr';
index(91).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(91).description = [{'Computes the Rayleigh range from the Gaussian beam parameter q'}];
index(91).keys = [{'Gaussian'},{'parameter'},{'q'},{'Rayleigh'},{'range'},{'zr'}];
index(91).cats = [{'GaussBeams'}];
index(92).name = 'FT_Rcw_to_w0z';
index(92).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(92).description = [{'Computes the waist radius and waist position from beam size w(z)'},{'and radius of curvature Rc(z)'}];
index(92).keys = [{'waist'},{'radius'},{'w0z'},{'position'},{'radius'},{'curvature'},{'Rcw'}];
index(92).cats = [{'GaussBeams'}];
index(93).name = 'FT_SG_field';
index(93).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(93).description = [{'Fills a 2D grip with the field amplitudes'},{'for a super-Gaussian beam at its waist'}];
index(93).keys = [{'2D'},{'fill'},{'field'},{'amplitude'},{'super'},{'Gaussian'},{'waist'}];
index(93).cats = [{'GaussBeams'}];
index(94).name = 'FT_ulp';
index(94).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(94).description = [{'Computes the field amplitude of a Laguerre-Gauss mode (helical)'}];
index(94).keys = [{'Laguerre'},{'mode'},{'Gauss'},{'field'},{'amplitude'}];
index(94).cats = [{'GaussBeams'}];
index(95).name = 'FT_ulp_cos';
index(95).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(95).description = [{'Computes the field amplitude of a Laguerre-Gauss mode (sinusoidal)'}];
index(95).keys = [{'Laguerre'},{'mode'},{'Gauss'},{'field'},{'amplitude'}];
index(95).cats = [{'GaussBeams'}];
index(96).name = 'FT_un';
index(96).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(96).description = [{'Computes the field amplitude of a 1D Hermite-Gauss mode'}];
index(96).keys = [{'Hermite'},{'mode'},{'Gauss'},{'field'},{'amplitude'}];
index(96).cats = [{'GaussBeams'}];
index(97).name = 'FT_unm';
index(97).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(97).description = [{'Computes the field amplitude of a Hermite-Gauss mode'}];
index(97).keys = [{'Hermite'},{'mode'},{'Gauss'},{'field'},{'amplitude'}];
index(97).cats = [{'GaussBeams'}];
index(98).name = 'FT_update_gauss_param';
index(98).path = '/Users/adf/work/git/simtools/src/GaussBeams';
index(98).description = [{'Computes the parameters of a Gaussian beam from the beam parameter'}];
index(98).keys = [{'Gaussian'},{'parameter'},{'q'},{'update'}];
index(98).cats = [{'GaussBeams'}];
index(99).name = 'FT_clipping_loss_LG';
index(99).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(99).description = [{'Computes the clipping loss experienced by a '},{'helical LG beam on a circular mirror'}];
index(99).keys = [{'clipping'},{'loss'},{'LG'},{'helical'}];
index(99).cats = [{'GaussBeams'},{'beam_analysis'}];
index(100).name = 'FT_fit_beam_size';
index(100).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(100).description = [{'Fits the beam size function to a set of measured sizes of a Gaussian'},{'beam to determine the beam waist size and position.'}];
index(100).keys = [{'size'},{'Gaussian'},{'waist'},{'position'}];
index(100).cats = [{'GaussBeams'},{'beam_analysis'}];
index(101).name = 'FT_fit_GaussBeam';
index(101).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(101).description = [{'Fits a Gaussian mode shape to a 2D data grid'}];
index(101).keys = [{'Gaussian'},{'mode'},{'fit'},{'2D'}];
index(101).cats = [{'GaussBeams'},{'beam_analysis'}];
index(102).name = 'FT_fit_GaussBeam_intensity';
index(102).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(102).description = [{'Fits a Gaussian mode shape to a 2D data grid'}];
index(102).keys = [{'Gaussian'},{'mode'},{'fit'},{'2D'}];
index(102).cats = [{'GaussBeams'},{'beam_analysis'}];
index(103).name = 'FT_fit_LG';
index(103).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(103).description = [{'Fits a helical LG mode shape to a 2D data grid'}];
index(103).keys = [{'fit'},{'LG'},{'mode'},{'2D'}];
index(103).cats = [{'GaussBeams'},{'beam_analysis'}];
index(104).name = 'FT_fit_LG_cos';
index(104).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(104).description = [{'Fits an LG mode shape to a 2D data grid'}];
index(104).keys = [{'fit'},{'LG'},{'mode'},{'2D'}];
index(104).cats = [{'GaussBeams'},{'beam_analysis'}];
index(105).name = 'FT_guess_center_LG';
index(105).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(105).description = [{'Guesses the center of an LG mode shape in a given 2D array'}];
index(105).keys = [{'guess'},{'center'},{'centre'},{'LG'},{'mode'},{'shape'},{'2D'}];
index(105).cats = [{'GaussBeams'},{'beam_analysis'}];
index(106).name = 'FT_guess_size_LG';
index(106).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(106).description = [{'Tries to guess the size of an LG mode shape in a given 2D array'}];
index(106).keys = [{'guess'},{'size'},{'LG'},{'mode'},{'2D'}];
index(106).cats = [{'GaussBeams'},{'beam_analysis'}];
index(107).name = 'FT_hg2lg';
index(107).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(107).description = [{'(no description)'}];
index(107).keys = [{'(no marker)'}];
index(107).cats = [{'GaussBeams'},{'beam_analysis'}];
index(108).name = 'FT_lg2hg';
index(108).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(108).description = [{'(no description)'}];
index(108).keys = [{'(no marker)'}];
index(108).cats = [{'GaussBeams'},{'beam_analysis'}];
index(109).name = 'FT_mode_content';
index(109).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(109).description = [{'Computes the deconvolution of a given field distribution,'},{'field_in, into Gaussian modes'}];
index(109).keys = [{'deconvolution'},{'field'},{'distribution'},{'Gaussian'},{'mode'},{'content'}];
index(109).cats = [{'GaussBeams'},{'beam_analysis'}];
index(110).name = 'FT_print_gauss_coefficients';
index(110).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(110).description = [{'Prints the content of a mode coefficient structure "gc"'}];
index(110).keys = [{'print'},{'content'},{'Gaussian'},{'mode'},{'coefficients'},{'gc'}];
index(110).cats = [{'GaussBeams'},{'beam_analysis'}];
index(111).name = 'FT_print_gauss_coefficients_to_file';
index(111).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(111).description = [{'Prints the content of a mode coefficient structure "gc"'}];
index(111).keys = [{'print'},{'content'},{'Gaussian'},{'mode'},{'coefficients'},{'gc'}];
index(111).cats = [{'GaussBeams'},{'beam_analysis'}];
index(112).name = 'FT_print_mode_coefficients';
index(112).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(112).description = [{'Prints the content of a mode coefficient structure "gc"'}];
index(112).keys = [{'print'},{'content'},{'mode'},{'coefficient'},{'gc'}];
index(112).cats = [{'GaussBeams'},{'beam_analysis'}];
index(113).name = 'FT_set_mode_coefficient';
index(113).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis';
index(113).description = [{'Sets the value of a mode coefficient in a structure "gc"'}];
index(113).keys = [{'set'},{'mode'},{'coefficient'},{'gc'}];
index(113).cats = [{'GaussBeams'},{'beam_analysis'}];
index(114).name = 'FTE_fit_LG';
index(114).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis/example';
index(114).description = [{'Example for fitting an LG mode shape to an CCD image'}];
index(114).keys = [{'example'},{'LG'},{'mode'},{'fit'},{'Gauss'}];
index(114).cats = [{'GaussBeams'},{'beam_analysis'},{'example'}];
index(115).name = 'FTE_hg2lg_example';
index(115).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis/example';
index(115).description = [{'(no description)'}];
index(115).keys = [{'(no marker)'}];
index(115).cats = [{'GaussBeams'},{'beam_analysis'},{'example'}];
index(116).name = 'FTE_lg2hg_example';
index(116).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis/example';
index(116).description = [{'(no description)'}];
index(116).keys = [{'(no marker)'}];
index(116).cats = [{'GaussBeams'},{'beam_analysis'},{'example'}];
index(117).name = 'FTE_make_test';
index(117).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis/example';
index(117).description = [{'(no description)'}];
index(117).keys = [{'(no marker)'}];
index(117).cats = [{'GaussBeams'},{'beam_analysis'},{'example'}];
index(118).name = 'FTE_mode_contribution';
index(118).path = '/Users/adf/work/git/simtools/src/GaussBeams/beam_analysis/example';
index(118).description = [{'Example for fitting modal decomposition of a Gauss beam'}];
index(118).keys = [{'example'},{'mode'},{'Gauss'},{'decomposition'},{'coefficient'}];
index(118).cats = [{'GaussBeams'},{'beam_analysis'},{'example'}];
index(119).name = 'FTE_plot_Gauss';
index(119).path = '/Users/adf/work/git/simtools/src/GaussBeams/example';
index(119).description = [{'Example for plotting a Gaussian beam profile'}];
index(119).keys = [{'example'},{'plot'},{'power'},{'Gauss'}];
index(119).cats = [{'GaussBeams'},{'example'}];
index(120).name = 'FTE_power_in_field';
index(120).path = '/Users/adf/work/git/simtools/src/GaussBeams/example';
index(120).description = [{'Example for using computing the total power in a complex field array.'}];
index(120).keys = [{'example'},{'field'},{'power'},{'Gauss'}];
index(120).cats = [{'GaussBeams'},{'example'}];
index(121).name = 'FT_Agilent6000_bin_to_ascii';
index(121).path = '/Users/adf/work/git/simtools/src/instruments';
index(121).description = [{'Reads a binary file saved by an Agilent 6000 scope and saves'},{'the data as an ascii file'}];
index(121).keys = [{'convert'},{'Agilent6000'},{'bin'},{'ascii'},{'data'}];
index(121).cats = [{'instruments'}];
index(122).name = 'FT_read_Agilent6000_ascii';
index(122).path = '/Users/adf/work/git/simtools/src/instruments';
index(122).description = [{'Reads an ascii data file saved by an Agilent 6000 scope'}];
index(122).keys = [{'read'},{'Agilent6000'},{'ascii'},{'data'}];
index(122).cats = [{'instruments'}];
index(123).name = 'FT_read_Agilent6000_bin';
index(123).path = '/Users/adf/work/git/simtools/src/instruments';
index(123).description = [{'Reads a binary data file saved by an Agilent 6000 scope'}];
index(123).keys = [{'read'},{'Agilent6000'},{'bin'},{'data'}];
index(123).cats = [{'instruments'}];
index(124).name = 'FT_read_Agilent6000_info';
index(124).path = '/Users/adf/work/git/simtools/src/instruments';
index(124).description = [{'Reads info file saved by an Agilent 6000 scope'}];
index(124).keys = [{'read'},{'Agilent6000'},{'info'}];
index(124).cats = [{'instruments'}];
index(125).name = 'FT_read_HPNA_ascii';
index(125).path = '/Users/adf/work/git/simtools/src/instruments';
index(125).description = [{'Reads an ascii data file saved by an HP network analyser'}];
index(125).keys = [{'read'},{'ascii'},{'data'},{'HP'},{'network'},{'analyser'}];
index(125).cats = [{'instruments'}];
index(126).name = 'FT_read_WinCamD_ascii';
index(126).path = '/Users/adf/work/git/simtools/src/instruments';
index(126).description = [{'Reads an ascii data file saved by an WinCamD beam analyzer'}];
index(126).keys = [{'read'},{'WinCamD'},{'ascii'},{'data'},{'beam'},{'analyzer'}];
index(126).cats = [{'instruments'}];
index(127).name = 'FT_calibrate_map_diameter';
index(127).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(127).description = [{'calibrates the delta x, y values of a map'}];
index(127).keys = [{'calibrate'},{'map'}];
index(127).cats = [{'mirror_maps'}];
index(128).name = 'FT_create_aperture_map';
index(128).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(128).description = [{'computes and writes an aperture (absorption) map'}];
index(128).keys = [{'aperture'},{'mirror'},{'map'},{'create'}];
index(128).cats = [{'mirror_maps'}];
index(129).name = 'FT_create_elliptical_aperture_map';
index(129).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(129).description = [{'(no description)'}];
index(129).keys = [{'(no marker)'}];
index(129).cats = [{'mirror_maps'}];
index(130).name = 'FT_create_sphere_for_map';
index(130).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(130).description = [{'(no description)'}];
index(130).keys = [{'(no marker)'}];
index(130).cats = [{'mirror_maps'}];
index(131).name = 'FT_find_map_radius';
index(131).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(131).description = [{'estimates the radius of a mirror given a mirror map'}];
index(131).keys = [{'radius'},{'mirror'},{'map'}];
index(131).cats = [{'mirror_maps'}];
index(132).name = 'FT_invert_mirror_map';
index(132).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(132).description = [{'inverts (flips) a mirror map'}];
index(132).keys = [{'mirror'},{'map'},{'invert'},{'flip'}];
index(132).cats = [{'mirror_maps'}];
index(133).name = 'FT_map_rms';
index(133).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(133).description = [{'Computes the rms surface distortion of a mirror surface map'}];
index(133).keys = [{'rms'},{'surface'},{'distortion'},{'mirror'},{'map'},{'root'},{'mean'},{'square'}];
index(133).cats = [{'mirror_maps'}];
index(134).name = 'FT_new_surface_map';
index(134).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(134).description = [{'(no description)'}];
index(134).keys = [{'(no marker)'}];
index(134).cats = [{'mirror_maps'}];
index(135).name = 'FT_plot_mirror_map';
index(135).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(135).description = [{'plots a mirror surface map'}];
index(135).keys = [{'plot'},{'mirror'},{'map'}];
index(135).cats = [{'mirror_maps'}];
index(136).name = 'FT_read_surface_map';
index(136).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(136).description = [{'(no description)'}];
index(136).keys = [{'(no marker)'}];
index(136).cats = [{'mirror_maps'}];
index(137).name = 'FT_read_zygo_map';
index(137).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(137).description = [{'Reads a mirror surface map in Zygo interferometer format'}];
index(137).keys = [{'zygo'},{'mirror'},{'map'},{'read'}];
index(137).cats = [{'mirror_maps'}];
index(138).name = 'FT_recenter_mirror_map';
index(138).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(138).description = [{'recenters a mirror map by computing the center of gravity'}];
index(138).keys = [{'mirror'},{'map'},{'center'}];
index(138).cats = [{'mirror_maps'}];
index(139).name = 'FT_remove_curvature_from_mirror_map';
index(139).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(139).description = [{'fits a curvature to a mirror map and removes it'}];
index(139).keys = [{'mirror'},{'map'},{'curvature'},{'fit'},{'remove'}];
index(139).cats = [{'mirror_maps'}];
index(140).name = 'FT_remove_elements_from_map';
index(140).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(140).description = [{'(no description)'}];
index(140).keys = [{'(no marker)'}];
index(140).cats = [{'mirror_maps'}];
index(141).name = 'FT_remove_elements_outside_map';
index(141).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(141).description = [{'Removes outer ring of NaN data from a mirror map'}];
index(141).keys = [{'map'},{'mirror'},{'remove'},{'data'},{'nan'}];
index(141).cats = [{'mirror_maps'}];
index(142).name = 'FT_remove_offset_from_mirror_map';
index(142).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(142).description = [{'removes an offset from a mirror map'}];
index(142).keys = [{'mirror'},{'map'},{'offset'},{'remove'}];
index(142).cats = [{'mirror_maps'}];
index(143).name = 'FT_remove_piston_from_mirror_map';
index(143).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(143).description = [{'fits a tilted plane to a mirror map and removes it'}];
index(143).keys = [{'mirror'},{'map'},{'tilt'},{'fit'},{'remove'}];
index(143).cats = [{'mirror_maps'}];
index(144).name = 'FT_select_area_in_map';
index(144).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(144).description = [{'(no description)'}];
index(144).keys = [{'(no marker)'}];
index(144).cats = [{'mirror_maps'}];
index(145).name = 'FT_write_map_fit_results';
index(145).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(145).description = [{'writes a the results of a surface fit to a map'}];
index(145).keys = [{'write'},{'map'},{'tilt'},{'curvature'},{'fit'}];
index(145).cats = [{'mirror_maps'}];
index(146).name = 'FT_write_surface_map';
index(146).path = '/Users/adf/work/git/simtools/src/mirror_maps';
index(146).description = [{'writes a mirror map into a file in Finesse readable format'}];
index(146).keys = [{'write'},{'map'},{'file'},{'Finesse'}];
index(146).cats = [{'mirror_maps'}];
index(147).name = 'FT_convert_ligo_map_for_finesse';
index(147).path = '/Users/adf/work/git/simtools/src/mirror_maps/ligo_maps';
index(147).description = [{'(no description)'}];
index(147).keys = [{'(no marker)'}];
index(147).cats = [{'mirror_maps'},{'ligo_maps'}];
index(148).name = 'FT_read_ligo_map';
index(148).path = '/Users/adf/work/git/simtools/src/mirror_maps/ligo_maps';
index(148).description = [{'(no description)'}];
index(148).keys = [{'(no marker)'}];
index(148).cats = [{'mirror_maps'},{'ligo_maps'}];
index(149).name = 'FT_convert_virgo_map_for_finesse';
index(149).path = '/Users/adf/work/git/simtools/src/mirror_maps/virgo_maps';
index(149).description = [{'converts a Virgo mirror map into Finess readable format'}];
index(149).keys = [{'mirror'},{'map'},{'Virgo'},{'Finesse'}];
index(149).cats = [{'mirror_maps'},{'virgo_maps'}];
index(150).name = 'FT_plot_virgo_map';
index(150).path = '/Users/adf/work/git/simtools/src/mirror_maps/virgo_maps';
index(150).description = [{'(no description)'}];
index(150).keys = [{'(no marker)'}];
index(150).cats = [{'mirror_maps'},{'virgo_maps'}];
index(151).name = 'FT_read_virgo_map';
index(151).path = '/Users/adf/work/git/simtools/src/mirror_maps/virgo_maps';
index(151).description = [{'(no description)'}];
index(151).keys = [{'(no marker)'}];
index(151).cats = [{'mirror_maps'},{'virgo_maps'}];
index(152).name = 'FT_virgo_aperture_map';
index(152).path = '/Users/adf/work/git/simtools/src/mirror_maps/virgo_maps';
index(152).description = [{'(no description)'}];
index(152).keys = [{'(no marker)'}];
index(152).cats = [{'mirror_maps'},{'virgo_maps'}];
index(153).name = 'FTE_zygo_map_01';
index(153).path = '/Users/adf/work/git/simtools/src/mirror_maps/zygo_map';
index(153).description = [{'Example for reading a Zygo mirror map'}];
index(153).keys = [{'zygo'},{'mirror'},{'map'},{'read'}];
index(153).cats = [{'mirror_maps'},{'zygo_map'}];
index(154).name = 'FTE_zygo_map_02';
index(154).path = '/Users/adf/work/git/simtools/src/mirror_maps/zygo_map';
index(154).description = [{'Example for reading a Zygo mirror map'}];
index(154).keys = [{'zygo'},{'mirror'},{'map'},{'read'}];
index(154).cats = [{'mirror_maps'},{'zygo_map'}];
index(155).name = 'FTE_zygo_map_03';
index(155).path = '/Users/adf/work/git/simtools/src/mirror_maps/zygo_map';
index(155).description = [{'Example for reading a Zygo mirror map'}];
index(155).keys = [{'zygo'},{'mirror'},{'map'},{'read'}];
index(155).cats = [{'mirror_maps'},{'zygo_map'}];
index(156).name = 'FTE_zygo_map_04';
index(156).path = '/Users/adf/work/git/simtools/src/mirror_maps/zygo_map';
index(156).description = [{'Example for reading a Zygo mirror map'}];
index(156).keys = [{'zygo'},{'mirror'},{'map'},{'read'}];
index(156).cats = [{'mirror_maps'},{'zygo_map'}];
index(157).name = 'FT_add_mirror_map';
index(157).path = '/Users/adf/work/git/simtools/src/optical_components';
index(157).description = [{'Computes mirror maps for reflection and transmission of a mirror'}];
index(157).keys = [{'add'},{'mirror'},{'map'}];
index(157).cats = [{'optical_components'}];
index(158).name = 'FT_cavity_fields';
index(158).path = '/Users/adf/work/git/simtools/src/optical_components';
index(158).description = [{'Computes the fields of a two mirror cavity'}];
index(158).keys = [{'field'},{'two'},{'mirror'}];
index(158).cats = [{'optical_components'}];
index(159).name = 'FT_cavity_roundtrip_Gouy';
index(159).path = '/Users/adf/work/git/simtools/src/optical_components';
index(159).description = [{'Computes the roundtrip Gouy phase of a cavity eigenmode'}];
index(159).keys = [{'Guoy'},{'phase'},{'roundtrip'},{'eigenmode'}];
index(159).cats = [{'optical_components'}];
index(160).name = 'FT_cavity_throughput';
index(160).path = '/Users/adf/work/git/simtools/src/optical_components';
index(160).description = [{'Computes the throughput of a cavity as a function of power'},{'transmittance and cavity finesse'}];
index(160).keys = [{'throughput'},{'transmittance'}];
index(160).cats = [{'optical_components'}];
index(161).name = 'FT_cavity_w2Rc';
index(161).path = '/Users/adf/work/git/simtools/src/optical_components';
index(161).description = [{'Computes mirror radius of curvature from beamsize for'},{'a linear, symmetric cavity'}];
index(161).keys = [{'radius'},{'curvature'}];
index(161).cats = [{'optical_components'}];
index(162).name = 'FT_fit_cavity_finesse';
index(162).path = '/Users/adf/work/git/simtools/src/optical_components';
index(162).description = [{'Fits the Airy function of a cavity to a measured scan of'},{'cavity throughput'}];
index(162).keys = [{'Airy'},{'throughput'}];
index(162).cats = [{'optical_components'}];
index(163).name = 'FT_init_cavity';
index(163).path = '/Users/adf/work/git/simtools/src/optical_components';
index(163).description = [{'Creates "cavity" structure for storing parameters of cavity'}];
index(163).keys = [{'init'},{'cavity'},{'structure'},{'parameter'}];
index(163).cats = [{'optical_components'}];
index(164).name = 'FT_init_mirror';
index(164).path = '/Users/adf/work/git/simtools/src/optical_components';
index(164).description = [{'Creates "mirror" structure for storing parameters of a mirror'}];
index(164).keys = [{'init'},{'mirror'},{'structure'},{'parameter'}];
index(164).cats = [{'optical_components'}];
index(165).name = 'FT_init_space';
index(165).path = '/Users/adf/work/git/simtools/src/optical_components';
index(165).description = [{'Creates "space" structure for storing parameters of a free space'}];
index(165).keys = [{'init'},{'free'},{'space'},{'structure'},{'parameter'},{'propagation'}];
index(165).cats = [{'optical_components'}];
index(166).name = 'FT_add_comment_char_to_line';
index(166).path = '/Users/adf/work/git/simtools/src/parse';
index(166).description = [{'(no description)'}];
index(166).keys = [{'(no marker)'}];
index(166).cats = [{'parse'}];
index(167).name = 'FT_get_element_from_line';
index(167).path = '/Users/adf/work/git/simtools/src/parse';
index(167).description = [{'(no description)'}];
index(167).keys = [{'(no marker)'}];
index(167).cats = [{'parse'}];
index(168).name = 'FT_parse_line';
index(168).path = '/Users/adf/work/git/simtools/src/parse';
index(168).description = [{'(no description)'}];
index(168).keys = [{'(no marker)'}];
index(168).cats = [{'parse'}];
index(169).name = 'FT_remove_comment_char_from_line';
index(169).path = '/Users/adf/work/git/simtools/src/parse';
index(169).description = [{'(no description)'}];
index(169).keys = [{'(no marker)'}];
index(169).cats = [{'parse'}];
index(170).name = 'FT_remove_comment_from_line';
index(170).path = '/Users/adf/work/git/simtools/src/parse';
index(170).description = [{'(no description)'}];
index(170).keys = [{'(no marker)'}];
index(170).cats = [{'parse'}];
index(171).name = 'FT_remove_comment_line';
index(171).path = '/Users/adf/work/git/simtools/src/parse';
index(171).description = [{'(no description)'}];
index(171).keys = [{'(no marker)'}];
index(171).cats = [{'parse'}];
index(172).name = 'FT_remove_phrase_from_string';
index(172).path = '/Users/adf/work/git/simtools/src/parse';
index(172).description = [{'(no description)'}];
index(172).keys = [{'(no marker)'}];
index(172).cats = [{'parse'}];
index(173).name = 'FT_replace_underscores';
index(173).path = '/Users/adf/work/git/simtools/src/parse';
index(173).description = [{'(no description)'}];
index(173).keys = [{'(no marker)'}];
index(173).cats = [{'parse'}];
index(174).name = 'FT_replace_value_in_line';
index(174).path = '/Users/adf/work/git/simtools/src/parse';
index(174).description = [{'(no description)'}];
index(174).keys = [{'(no marker)'}];
index(174).cats = [{'parse'}];
index(175).name = 'FT_split_line';
index(175).path = '/Users/adf/work/git/simtools/src/parse';
index(175).description = [{'(no description)'}];
index(175).keys = [{'(no marker)'}];
index(175).cats = [{'parse'}];
index(176).name = 'FT_uncomment_line';
index(176).path = '/Users/adf/work/git/simtools/src/parse';
index(176).description = [{'(no description)'}];
index(176).keys = [{'(no marker)'}];
index(176).cats = [{'parse'}];
index(177).name = 'FT_blur_data';
index(177).path = '/Users/adf/work/git/simtools/src/utils';
index(177).description = [{'Blurs a 2D data array with a Gaussian filter'}];
index(177).keys = [{'blur'},{'2D'},{'Gaussian'},{'filter'},{'data'}];
index(177).cats = [{'utils'}];
index(178).name = 'FT_box_data';
index(178).path = '/Users/adf/work/git/simtools/src/utils';
index(178).description = [{'Selects a subset of a 2D data grid,'},{'such that it contains all data > threshold'}];
index(178).keys = [{'box'},{'data'},{'subset'},{'2D'},{'threshold'}];
index(178).cats = [{'utils'}];
index(179).name = 'FT_center_of_mass';
index(179).path = '/Users/adf/work/git/simtools/src/utils';
index(179).description = [{'Computes the center of mass of a data array and returns the coordinates'}];
index(179).keys = [{'center'},{'centre'},{'mass'},{'com'},{'data'}];
index(179).cats = [{'utils'}];
index(180).name = 'FT_create_tmp_filename';
index(180).path = '/Users/adf/work/git/simtools/src/utils';
index(180).description = [{'Creates a name for temporary files using the current datestring'}];
index(180).keys = [{'date'},{'time'},{'datetime'},{'datestring'},{'temporary'},{'create'},{'tmp'},{'filename'}];
index(180).cats = [{'utils'}];
index(181).name = 'FT_datestring';
index(181).path = '/Users/adf/work/git/simtools/src/utils';
index(181).description = [{'Creates datestring of current date and time'}];
index(181).keys = [{'date'},{'time'},{'datetime'},{'datestring'},{'create'}];
index(181).cats = [{'utils'}];
index(182).name = 'FT_message';
index(182).path = '/Users/adf/work/git/simtools/src/utils';
index(182).description = [{'prints a message to stdout'}];
index(182).keys = [{'print'},{'message'},{'warning'}];
index(182).cats = [{'utils'}];
index(183).name = 'FT_normalise_data';
index(183).path = '/Users/adf/work/git/simtools/src/utils';
index(183).description = [{'Normalises a data set so that max/min values are those given by user'}];
index(183).keys = [{'normalise'},{'data'},{'max'},{'min'},{'maximum'},{'minimum'}];
index(183).cats = [{'utils'}];
index(184).name = 'FT_remove_piston_data';
index(184).path = '/Users/adf/work/git/simtools/src/utils';
index(184).description = [{'Removes a tilt from a 2D data array'}];
index(184).keys = [{'remove'},{'tilt'},{'2D'},{'piston'},{'data'}];
index(184).cats = [{'utils'}];
index(185).name = 'FT_rotate_2D';
index(185).path = '/Users/adf/work/git/simtools/src/utils';
index(185).description = [{'Rotates a 2D data grid by a given angle'}];
index(185).keys = [{'rotate'},{'2D'},{'angle'}];
index(185).cats = [{'utils'}];
index(186).name = 'FT_warning';
index(186).path = '/Users/adf/work/git/simtools/src/utils';
index(186).description = [{'prints a message to stdout'}];
index(186).keys = [{'print'},{'message'},{'warning'}];
index(186).cats = [{'utils'}];
index(187).name = 'FT_flip_colormap';
index(187).path = '/Users/adf/work/git/simtools/src/utils/colormaps';
index(187).description = [{'Returns colormap, good for bipolar signals'}];
index(187).keys = [{'colormap'},{'colourmap'},{'color'},{'colour'},{'bipolar'},{'flip'}];
index(187).cats = [{'utils'},{'colormaps'}];
index(188).name = 'FT_neg_colormap';
index(188).path = '/Users/adf/work/git/simtools/src/utils/colormaps';
index(188).description = [{'Returns negative part of FT_flip_colormap'}];
index(188).keys = [{'colormap'},{'colourmap'},{'color'},{'colour'},{'negative'},{'neg'},{'FT_flip_colormap'}];
index(188).cats = [{'utils'},{'colormaps'}];
index(189).name = 'FT_pos_colormap';
index(189).path = '/Users/adf/work/git/simtools/src/utils/colormaps';
index(189).description = [{'Returns positive part of FT_flip_colormap'}];
index(189).keys = [{'colormap'},{'colourmap'},{'color'},{'colour'},{'positive'},{'pos'},{'FT_flip_colormap'}];
index(189).cats = [{'utils'},{'colormaps'}];
index(190).name = 'FTE_rotate';
index(190).path = '/Users/adf/work/git/simtools/src/utils/example';
index(190).description = [{'(no description)'}];
index(190).keys = [{'(no marker)'}];
index(190).cats = [{'utils'},{'example'}];
index(191).name = 'FT_check_for_gzip';
index(191).path = '/Users/adf/work/git/simtools/src/utils/fileutils';
index(191).description = [{'Checks if a filename ends in .gz and if so unzips it'}];
index(191).keys = [{'file'},{'gzip'},{'unzip'},{'zip'}];
index(191).cats = [{'utils'},{'fileutils'}];
index(192).name = 'FT_delete_file';
index(192).path = '/Users/adf/work/git/simtools/src/utils/fileutils';
index(192).description = [{'(no description)'}];
index(192).keys = [{'(no marker)'}];
index(192).cats = [{'utils'},{'fileutils'}];
index(193).name = 'FT_files_in_folder';
index(193).path = '/Users/adf/work/git/simtools/src/utils/fileutils';
index(193).description = [{'Lists all files with a given extension in a folder'}];
index(193).keys = [{'file'},{'list'},{'folder'}];
index(193).cats = [{'utils'},{'fileutils'}];
index(194).name = 'FT_find_text_in_file';
index(194).path = '/Users/adf/work/git/simtools/src/utils/fileutils';
index(194).description = [{'(no description)'}];
index(194).keys = [{'(no marker)'}];
index(194).cats = [{'utils'},{'fileutils'}];
index(195).name = 'FT_make_backup';
index(195).path = '/Users/adf/work/git/simtools/src/utils/fileutils';
index(195).description = [{'(no description)'}];
index(195).keys = [{'(no marker)'}];
index(195).cats = [{'utils'},{'fileutils'}];
index(196).name = 'FT_remove_file_extension';
index(196).path = '/Users/adf/work/git/simtools/src/utils/fileutils';
index(196).description = [{'(no description)'}];
index(196).keys = [{'(no marker)'}];
index(196).cats = [{'utils'},{'fileutils'}];
index(197).name = 'FT_bincoeff';
index(197).path = '/Users/adf/work/git/simtools/src/utils/math_utils';
index(197).description = [{'(no description)'}];
index(197).keys = [{'(no marker)'}];
index(197).cats = [{'utils'},{'math_utils'}];
index(198).name = 'FT_binomial';
index(198).path = '/Users/adf/work/git/simtools/src/utils/math_utils';
index(198).description = [{'(no description)'}];
index(198).keys = [{'(no marker)'}];
index(198).cats = [{'utils'},{'math_utils'}];
index(199).name = 'FT_JacobiPol';
index(199).path = '/Users/adf/work/git/simtools/src/utils/math_utils';
index(199).description = [{'computes the Jacobi polynomial'}];
index(199).keys = [{'Jacobi'},{'polynomial'}];
index(199).cats = [{'utils'},{'math_utils'}];
index(200).name = 'FT_kd';
index(200).path = '/Users/adf/work/git/simtools/src/utils/math_utils';
index(200).description = [{'Computes the Kronecker delta function'}];
index(200).keys = [{'math'},{'Kronecker'},{'delta'}];
index(200).cats = [{'utils'},{'math_utils'}];
index(201).name = 'FT_LaguerrePol';
index(201).path = '/Users/adf/work/git/simtools/src/utils/math_utils';
index(201).description = [{'(no description)'}];
index(201).keys = [{'(no marker)'}];
index(201).cats = [{'utils'},{'math_utils'}];
index(202).name = 'FT_log_ticks';
index(202).path = '/Users/adf/work/git/simtools/src/utils/matlab_utils';
index(202).description = [{'Generates a string for setting major tick marks in a plot'}];
index(202).keys = [{'major'},{'tick'},{'mark'},{'plot'},{'log'}];
index(202).cats = [{'utils'},{'matlab_utils'}];
index(203).name = 'FT_print_progress';
index(203).path = '/Users/adf/work/git/simtools/src/utils/timer';
index(203).description = [{'Prints a progress statement in a loop'}];
index(203).keys = [{'progress'}];
index(203).cats = [{'utils'},{'timer'}];
