%---------------------------------------------------------------------  
% function [block] = FT_write_kat_constant(block,constant_name, value)
% 
% Overwrite the value of the given constant by a new value
%
% block: block structure 
% constant_name: string, name of the constant
% value: new value of the constant (string or numerical value)
%
% Part of the SimTools package
% Andreas Freise 17.06.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [block] = FT_write_kat_constant(block,constant_name, value)

  baseid='FT_write_kat_constant';
    
  if (~isstruct(block))
    msgid=[baseid,':checkinarg'];
    result='first input argument must be a block structure';
    error(msgid,result);
  end
  
  if (~isstr(constant_name))
    msgid=[baseid,':checkinarg'];
    result='second input argument must be a string';
    error(msgid,result);
  end
  
  bl=length(block);
  if (bl>1)
    msgid=[baseid,':checksize'];
    error(msgid,'first argument must be single FTblock');
  end
  
  lines=[];
  tmp_lines=FT_find_element_in_active_block(block,2,constant_name);
  % check whether we really found the constant
  for i=1:length(tmp_lines)
    [element,estart,eend]=FT_get_element_from_line(block.txt_lines(tmp_lines(i)),1);
    if (strcmp(element,'const'))
      lines=[lines,tmp_lines(i)];
    end
  end
  
  if (length(lines)<1)
    msgid=[baseid,':find_constant'];
    error(msgid,'could not find named constant');
  end

  if (length(lines)>1)
    msgid=[baseid,':find_constant'];
    error(msgid,'found two instances of named constant');
  end

  % replacing old value by new
  block.txt_lines(lines)={FT_replace_value_in_line(block.txt_lines(lines),3,value)};
  
  
