%---------------------------------------------------------------------  
% function [found, blockname] = FT_search_string_for_block_commands(instring)
% 
% Searches a text line for start or stop markers of a block:
% '%%% FTblock' markes a block start, '%%% FTend' marks a block end.
% If a block start is found then its name (given after '%%% FTblock') 
% is returned.
%
% instring: string containing text lines
% blockname: string contains the name of a found block
% found: integer, status code
%        0: no block command was found
%        1: block start command was found
%        2: block end command was found
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [found, blockname] = FT_search_string_for_block_commands(instring)

  % base string for error message id
  baseid='FT_search_string_for_block_commands';

  if (~isstr(instring))
    msgid=[baseid,':checkinarg'];
    msg='input argument must be a filename';
    error(msgid,msg);
  end
  
  
  found=0;
  blockname='';
  
  outstring=strtrim(instring);

  startstring='FTblock';
  stopstring='FTend';
  
  if (strfind(instring,'%%%'))
    % found block start/end
    namepos=strfind(instring,startstring);
    if (namepos)
      blockname=strtrim(instring(namepos+7:length(instring)));
      if (blockname)
        found=1;
        % check for whitespace characters inside blockname
        tmperror=max(isspace(blockname));
        if (tmperror)
          msgid=[baseid,':checkname'];
          error(msgid,'"%s" is not a valid block name', blockname);
        end
      else
        msgid=[baseid,':checkname'];
        error(msgid,'line "%s": could not read block name', instring);
      end
    else
      if (strfind(instring,stopstring))
        found=2;
      end
    end
  end
  
        
