%---------------------------------------------------------------------  
% function [block] = FT_remove_lines_from_block(block,line_numbers)
% 
% Removes text lines given by their line numbers from a block
%
% block: block structure
% line_numbers: vector of integers, specifying lines to be removed
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [block] = FT_remove_lines_from_block(block,line_numbers)

  baseid='FT_remove_lines_from_block';
    
  if (~isstruct(block))
    msgid=[baseid,':checkinarg'];
    result='first input argument must be a block structure';
    error(msgid,result);
  end
  
  if (~isnumeric(line_numbers))
    msgid=[baseid,':checkinarg'];
    result='second input argument must be numeric';
    error(msgid,result);
  end

  if (line_numbers>block.n_lines)
    msgid=[baseid,':checkinarg'];
    result='line numbers given larger than block length';
    error(msgid,result);    
  end

  block.txt_lines(line_numbers)=[];
  block.n_lines=block.n_lines-length(line_numbers);
  block.edited = 1;
    
  