%---------------------------------------------------------------------  
% function [] = FT_print_block(blocks, name)
% 
% Print one block from a list, given by the block name.
%
% blocks: vector of blocks
% name: name or index of block to be printed
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

 function [] = FT_print_block(blocks, name)

  % base string for error message id
  baseid='FT_print_block';

  if (isstr(name))
    index=FT_index_of_block(blocks,name);
  else 
    if (isnumeric(name))
      index=name;
    else
      msgid=[baseid,':checkinarg'];
      result='could not find block name or index';
      error(msgid,result);
    end
  end

  outblock=blocks(index);
  disp(outblock.txt_lines(:));