%---------------------------------------------------------------------  
% function [] = FT_list_block_names(blocks)
% 
% List the names of all blocks in the list given by 'block'
%
% blocks: vector of blocks
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  


 function [] = FT_list_block_names(blocks)

  % base string for error message id
  baseid='FT_list_block_names';

  if (~isstruct(blocks))
    msgid=[baseid,':checkinarg'];
    msg='input argument must be a block structure';
    error(msgid,msg);
  end
  
  tmpstr='';
  for i=1:length(blocks)
    tmpstr=[tmpstr,blocks(i).name,' '];
  end
  disp(tmpstr);
