%---------------------------------------------------------------------  
% function [index] = FT_index_of_block(block, name)
% 
% Returns the index of a block given by name in a list of blocks
%
% blocks: vector of blocks
% name: string, block name to search for
% index: integer, specifying block index in 'blocks'
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

 function [index] = FT_index_of_block(blocks, name)

  % base string for error message id
  baseid='FT_index_of_block';

  if (~isstruct(blocks))
    msgid=[baseid,':checkinarg'];
    msg='first input argument must be a block structure';
    error(msgid,msg);
  end

  if (~isstr(name))
    msgid=[baseid,':checkinarg'];
    msg='second input argument must be a string';
    error(msgid,msg);
  end

  bl=length(blocks);
  i=1;
  index=0;
  found=0;
  while (i<=bl && found==0)
    found=strncmp(blocks(i).name,name,length(name));
    if (found)
      index=i;
    end
    i=i+1;
  end
  
  if (found==0)
    msgid=[baseid,':copyblock'];
    msg=sprintf('could not find block named "%s"',name);
    error(msgid,msg);
  end
  
  